function escapeHtml(v) {
    if(!v || !v.replace) return v;
  return v.replace(/"/g, '&quot;').replace(/'/g, '&#39;').replace(/\(/g, '&#28;').replace(/\)/g, '&#29;').replace(/</g, "&lt;").replace(/>/g, "&gt;")
}
var extendMemberModel = (function() {
  // 拼接单选框
  var getRadios = function(data, extenddata) {
    var html = '<div class="col-sm-6 col-xs-9">';
    var arr = [];
    var check = extenddata[data.code] || '';
    if (data.listOptions) {
      arr = (data.listOptions.substring(6)).split('||')
    }
    for (var i = 0 ; i < arr.length; i++) {
      var opt = arr[i].split('=');
      var id = "extend" + data.code + i;
      if (data.defaultValue === opt[0] || (check && check.split(',').indexOf(opt[0]) > -1)) {
        html += '<label class="radio-inline"><input name="extend' + data.code + '" type="radio" checked="checked" id="' + id +'" value="' + opt[0] +'">' + opt[1] + '</label>';
      } else {
        html += '<label class="radio-inline"><input name="extend' + data.code + '" type="radio" id="' + id +'" value="' + opt[0] +'">' + opt[1] + '</label>';
      }
    }
    html += "</div></div>";
    return html;
  }
  //  拼接多选框
  var getCheckBoxs = function(data, extenddata) {
    var html = '<div class="col-sm-6 col-xs-9">';
    var arr = [];
    var check = extenddata[data.code] || '';
    if (data.listOptions) {
      arr = (data.listOptions.substring(6)).split('||')
    }
    for (var i = 0 ; i < arr.length; i++) {
      var opt = arr[i].split('=');
      var defaultValue = data.defaultValue.split(',')
      var id = "extend" + data.code + i;
      if (defaultValue[i] === opt[0] || (check && check.split(',').indexOf(opt[0]) > -1)) {
        html += '<label class="checkbox-inline"><input type="checkbox" id="' + id +'" value="' + opt[0] +'" name="extend' + data.code + '" checked="true">' + opt[1] + '</label>';
      } else {
        html += '<label class="checkbox-inline"><input type="checkbox" id="' + id +'" value="' + opt[0] +'" name="extend' + data.code + '">' + opt[1] + '</label>';
      }
    }
    html += "</div></div>";
    return html
  }
  // 拼接下拉框
  var getSelect = function(data) {
    var html = '<div class="col-sm-6 col-xs-9">';
    if (data.verifyRule) {
      html += '<select id="extend' + data.code +'" name="' + data.code + '" class=" form-control" verify="' + data.verifyRule + '"><option value=""></option>';
    } else {
      html += '<select id="extend' + data.code +'" name="' + data.code + '" class=" form-control"><option value=""></option>';
    }
    var arr = [];
    if (data.listOptions) {
      arr = (data.listOptions.substring(6)).split('||')
    }
    for (var i = 0 ; i < arr.length; i++) {
      var opt = arr[i].split('=');
      if (data.defaultValue === opt[0]) {
        html += '<option selected="true" value="' + opt[0] +'">' + opt[1] + '</option>';
      } else {
        html += '<option value="' + opt[0] +'">' + opt[1] + '</option>';
      }
    }
    if (data.verifyRule) {
      html += '</select><span class="verify-success form-control-feedback" style="display:none; right: 15px" aria-hidden="true"><span class="fa fa-check-circle"></span></span><span class="verify-mandatory form-control-feedback" style="color:red; right: 15px" ztype="Verify">*</span><span class="verify-message help-block text-left" style="display:none; right: 15px"><li style="color:red">不能为空</li></span></div></div>';
    } else {
      html += '</select></div></div>';
    }
    return html;
  }
  // 初始化事件
  var initEvent = function(fieldGroups) {
    for (var i = 0; i < fieldGroups.length; i++) {
      var fieldGroup = fieldGroups[i];
      var fileds = fieldGroup.columns;
      for (var j = 0; j < fileds.length; j++) {
        var item = fileds[j];
        var id = '#extend' + item.code;
        if (item.verifyRule) {
          if (item.controlType === 'Checkbox') {
            id = '#extend' + item.code + i;
            $(id).change(function(){
              var arr = $(this).parent().siblings().children();
              var value = false
              if ($(this).prop("checked")) {
                value = true
              } else {
                for (var k = 0; k < arr.length; k++) {
                  if ($(arr[k]).prop("checked")) {
                    value = true
                    break
                  }
                }
              }
              if (value) {
                $(this).parent().css('color', '#505050')
                $(this).parent().siblings().css('color', '#505050')
              } else {
                $(this).parent().css('color', 'red')
                $(this).parent().siblings().css('color', 'red')
              }
            })
          }
          if (item.controlType === 'Select') {
            bindEvents(id, ['change'])
          }
          if (item.controlType === 'Text' || item.controlType === 'TextArea') {
            bindEvents(id, ['focus', 'blur', 'input'])
          }
        }
      }
    }
  }
  // 事件绑定
  var bindEvents = function(id, events) {
    for (var i = 0; i < events.length; i++) {
      var evnt = events[i]
      $(id).on(evnt, function(){
        var value = $(this).val();
        var context = this
        setClass(value, context)
      })
    }
  }
  var setClass = function(value, context) {
    var siblings = $(context).siblings();
    if (!value) {
      $(siblings[2]).show()
      $(siblings[0]).hide()
      $(siblings[1]).show()
      $(context).css('border-color', '#a94442')
      return false
    } else {
      $(siblings[0]).show()
      $(siblings[2]).hide()
      $(siblings[1]).hide()
      $(context).css('border-color', '#ccc')
      return true
    }
  }
  // 校验必填项
  var checkData = function(_fieldGroups) {
    var flag = true
    var fieldGroups = _fieldGroups || window.fieldGroups || []
    for (var i = 0; i < fieldGroups.length; i++) {
      var fieldGroup = fieldGroups[i];
      var fileds = fieldGroup.columns;
      for (var j = 0; j < fileds.length; j++) {
        var item = fileds[j];
        var id = '#extend' + item.code;
        if (item.verifyRule) {
          if (item.controlType === 'Checkbox') {
            id = '#extend' + item.code + i
            var value = false
            var arr = $(id).parent().siblings().children();
            if ($(id).prop("checked")) {
              value = true
            } else {
              for (var k = 0; k < arr.length; k++) {
                if ($(arr[k]).prop("checked")) {
                  value = true
                  break
                }
              }
            }
            if (value) {
              $(id).parent().css('color', '#505050')
              $(id).parent().siblings().css('color', '#505050')
            } else {
              flag = false
              $(id).parent().css('color', 'red')
              $(id).parent().siblings().css('color', 'red')
            }
          }
          if (item.controlType === 'Select') {
            var value = $(id).val();
            if (flag) {
              flag = setClass(value, $(id));
            } else {
              setClass(value, $(id));
            }
          }
          if (item.controlType === 'Text' || item.controlType === 'TextArea') {
            var value = $(id).val();
            if (flag) {
              flag = setClass(value, $(id));
            } else {
              setClass(value, $(id));
            }
          }
        }
      }
    }
    return flag
  }
  // 拼接拓展模型字符串
  var init = function(data) {
    var extendcods = [];
    var extend = data.extend;
    var extenddata = {};
    if (extend) {
      extenddata = $.parseJSON(extend);
    }
    var extendmodel = data.extendmodel;
    var htmlStr = '';
    if (!extendmodel) {
      return;
    }
    var fieldGroups = $.parseJSON(extendmodel);
    window.fieldGroups = fieldGroups
    var textarea= {}
    for (var i = 0; i < fieldGroups.length; i++) {
      var fieldGroup = fieldGroups[i];
      var fileds = fieldGroup.columns;
      htmlStr += "<div class='b-b b-light m-b-md'><div class='m-xs'><h4>" +
      escapeHtml(fieldGroups[i].name) + "</h4></div></div>";
      if (!fileds || !fileds.length) {
        continue;
      }
      for (var j = 0; j < fileds.length; j++) {
        var aclass;
        if (j == 0) {
          aclass = 'm-t-lg';
        } else {
          aclass = '';
        }
        htmlStr += "<div class='form-group " + aclass + "'><label for='" + escapeHtml(fileds[j].code) +
          "' class='col-xs-3 control-label'>" +
          escapeHtml(fileds[j].name) + "：</label>";
        var codekey = escapeHtml(fileds[j].code);
        extendcods.push(codekey);
        var codevalue = escapeHtml(extenddata[codekey]);
        if(!codevalue) {
          codevalue = "";
        }
        var type = fileds[j].controlType.toLocaleLowerCase()
        if (type === 'radio') {
          htmlStr += getRadios(fileds[j], extenddata)
        } else if (type === 'checkbox') {
          htmlStr += getCheckBoxs(fileds[j], extenddata)
        } else if (type === 'datetime' || type === 'date') {
          htmlStr += "<div class='col-sm-6 col-xs-9'><input type='date' class='form-control' id='extend"
            + codekey + "' value='"
            + codevalue.substring(0, 10) +"' />"
            + "</div></div>";
        } else if (type === 'textarea') {
          if (fileds[j].verifyRule) {
            htmlStr += '<div class="col-sm-6 col-xs-9"><textarea id="extend' + codekey +'" name="extend' + codekey + '" class="form-control" style="resize: auto"></textarea><span class="verify-success form-control-feedback" style="display:none; right: 15px" aria-hidden="true"><span class="fa fa-check-circle"></span></span><span class="verify-mandatory form-control-feedback" style="color:red; right: 15px" ztype="Verify">*</span><span class="verify-message help-block text-left" style="display:none; right: 15px"><li style="color:red">不能为空</li></span></div></div>'
          } else {
            htmlStr += '<div class="col-sm-6 col-xs-9"><textarea id="extend' + codekey +'" name="extend' + codekey + '" class="form-control" style="resize: auto"></textarea></div></div>'
          }
          textarea['#extend' + codekey] = codevalue
        } else if (type === 'select') {
          htmlStr += getSelect(fileds[j])
        } else {
          htmlStr += "<div class='col-sm-6 col-xs-9'><input type='" + type + "' class='form-control' id='extend"
                  + codekey + "' value='"
                  + codevalue +"' />";
          if (fileds[j].verifyRule) {
            htmlStr += '<span class="verify-success form-control-feedback" style="display:none; right: 15px" aria-hidden="true"><span class="fa fa-check-circle"></span></span><span class="verify-mandatory form-control-feedback" style="color:red; right: 15px" ztype="Verify">*</span><span class="verify-message help-block text-left" style="display:none; right: 15px"><li style="color:red">不能为空</li></span></div></div>';
          } else {
            htmlStr += '</div></div>'
          }
        }
      }
    }
    return {
      textarea: textarea,
      htmlStr: htmlStr,
      extendcods: extendcods
    }
  }
  return {
    init: init,
    checkData: checkData,
    initEvent: initEvent
  }
})()
