;(function (window, document, vjs, undefined) {
  "use strict";

  var
    isFlash = function () {
      var flag = false;
      if (window.ActiveXObject) {
        try {
          var swf = new ActiveXObject("ShockwaveFlash.ShockwaveFlash");
          if (swf) {
            flag = true;
          }
        } catch (e) {
        }
      } else {
        try {
          var swf = navigator.plugins['Shockwave Flash'];
          if (swf) {
            flag = true;
          }
        } catch (e) {
        }
      }
      return flag;
    },

    showRecommend = function (recommends) {
      var html = '';
      if ({}.toString.call(recommends) === '[object Array]') {
        recommends.forEach(function (v) {
          html += '<a class="item" target="_blank" href="' + v.playLink + '"  title="' + v.title + '">\n' +
            '<div class="img-box">\n' +
            '<img src="' + v.picUrl + '" alt="">\n' +
            '</div>\n' +
            '<div class="right-box">\n' +
            '<div class="title">\n' +
            '<div>' + v.title + '</div>\n' +
            '</div>\n' +
            '<div class="bottom">\n' +
            '<div>播放: ' + v.playAmount + '</div>\n' +
            '<div>' + v.totalTime + '</div>\n' +
            '</div>\n' +
            '</div>\n' +
            '</a>';
        });
      }
      return html;
    },

    loadCssCode = function (cssStr, styleElId) {
		var styleEl = document.getElementById(styleElId);
		if (!styleEl) {
			styleEl = document.createElement('style');
			styleEl.type = 'text/css';
			styleEl.id = styleElId;
			document.getElementsByTagName('head')[0].appendChild(styleEl);
		}
		if (styleEl.styleSheet) { // IE10-
			styleEl.styleSheet.cssText += cssStr;
		} else { // 非IE IE11+
			cssStr = document.createTextNode(cssStr);
			styleEl.appendChild(cssStr);
		}
    },

    registerPlugin = vjs.registerPlugin || vjs.plugin,
    indexCss = '.video-js.videojs-zving .vjs-time-control{display:block}'
       + '.video-js.videojs-zving .vjs-remaining-time{display:none}'
       + '.video-js.videojs-zving .vjs-big-play-button{font-size:2.5em;line-height:2.3em;height:2.5em;width:2.5em;-webkit-border-radius:2.5em;-moz-border-radius:2.5em;border-radius:2.5em;background-color:#73859f;background-color:rgba(115, 133, 159, .5);border-width:.15em;margin-top:-1.25em;margin-left:-1.25em}'
       + '.video-js.videojs-zving .vjs-big-play-button .vjs-icon-placeholder{}'
       + '.video-js.videojs-zving .vjs-loading-spinner{font-size:2.5em;width:2em;height:2em;border-radius:1em;margin-top:-1em;margin-left:-1.5em}'
       + '.video-js.videojs-zving .vjs-paused.vjs-has-started .vjs-big-play-button{display:block}'
       + '.videojs-zving .ad-control{display:block;position:absolute;top:1em;right:1em;z-index:1112;padding:5px 10px;border:1px solid #fff;border-radius:10px;cursor:pointer;opacity:0.8;}'
       + '.zving-mask-ed{position:absolute;width:100%;height:100%;background:#000;opacity:.7;justify-content:center}'
       + '.zving-mask-ed > div{margin:0 3em}'
       + '.zving-mask-ed .replay,.zving-mask-ed .share{display:flex;flex-direction:column;align-items:center;cursor:pointer}'
       + '.zving-mask-ed .replay img,.zving-mask-ed .share img{width:35px}'
       + '.zving-mask-ed .replay span,.zving-mask-ed .share span{padding-top:5px}'
       + '.videojs-zving .ad-content{position:absolute;top:50%;left:50%;transform:translate(-50%, -50%);z-index:2}'
       + '.videojs-zving .ad-content img{max-width: inherit;}'
       + '.videojs-zving object{display:block;margin:0 auto;background:transparent}'
       + '.videojs-zving .close-content{position:absolute;top:10px;right:-28px;width:20px;height:20px;border-radius:50%;background:#fff;cursor:pointer}'
       + '.videojs-zving .close{width:2px;height:15px;background:#000;position:relative;transform:rotate(-45deg);margin-left:9px;margin-top:3px;float:none;}'
       + '.videojs-zving .close::before{content:\'\';position:absolute;width:100%;height:100%;transform:rotate(90deg);background:#000}'
       + '.videojs-zving .logo{position:absolute;top:10px;right:10px;width:60px;height:50px;cursor:pointer;z-index:1}'
       + '.videojs-zving .logo img{width:100%;height:100%}'
       + '.zving-mask-ed{display:flex;align-items:center}'
       + '.videojs-zving .ad-click{display:block;transform:translate(-50%, -50%);top:50%;left:50%;position:absolute}'
       + '.zving-mask-ed > div:nth-child(1){flex-shrink:0;display:flex}'
       + '.zving-mask-ed > div:nth-child(1) .replay{margin:0 10px}'
       + '.zving-mask-ed .play-list{display:flex;flex-direction:column}'
       + '.zving-mask-ed .play-list .item{display:flex;margin:5px 0;cursor:pointer}'
       + '.zving-mask-ed .play-list .item .img-box{width:100px;height:60px;margin-right:10px;flex-shrink:0}'
       + '.zving-mask-ed .play-list .item .img-box img{width:100%;height:100%}'
       + '.zving-mask-ed .play-list .item .right-box{display:flex;flex-direction:column;justify-content:space-between;color:gray}'
       + '.zving-mask-ed .play-list .item:hover .right-box{color:#fff}'
       + '.shareWrap{position:absolute;top:50%;left:50%;transform:translate(-50%, -50%);width:460px;padding:10px;background:#fff;border:1px solid #CCC;box-shadow:0 0 2px #D4D9DD inset;z-index:10}'
       + '.shareWrap .shareTitle{height:24px;line-height:24px;border-bottom:1px dotted #e7e7e7;padding-bottom:6px}'
       + '.shareWrap .shareTitle .shareClose{float:right;vertical-align:middle;cursor:pointer;margin-top:5px;background:url(data:image/gif;base64,R0lGODlhCQAKAIABAKOjo////yH5BAEAAAEALAAAAAAJAAoAAAIQBIJom+vxHFOvVShPzHbaAgA7) no-repeat left top;width:10px;height:10px;line-height:10px}'
       + '.shareWrap .shareCon{padding:5px 20px}'
       + '.bshare-custom{display:inline-block;vertical-align:middle}'
       + '.bshare-sinaminiblog{display:inline-block;width:30px;height:30px;background:url(data:image/png;base64,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);display:inline-block;background-size:100%}'
       +'.bshare-weixin{display:inline-block;width:30px;height:30px;background:url(data:image/png;base64,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);display:inline-block;background-size:100%}'
       +'.bshare-qqim{display:inline-block;width:30px;height:30px;background:url(data:image/png;base64,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);display:inline-block;background-size:100%}'
       +'.bshare-qqmb{display:inline-block;width:30px;height:30px;background:url(data:image/png;base64,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);display:inline-block;background-size:100%}'
       + '.bshare-douban{display:inline-block;width:30px;height:30px;background:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAMgAAADICAYAAACtWK6eAAANVElEQVR4Xu2dv2/cyBXH31tFNnAIYAVJlQNyuwoCpIop3B9wujZIYF3+ActVypMK78LVyc0ddg+I5O46y106yZc/wEqdH0sXKbNL44BUKSTAReAffAFpyV6tyCVnRC5n+L4C3HhnyHmfN58dcoacZcIfCIBALgEGGxAAgXwCEAS9AwQWEIAg6B4gAEHQB0DAjgBGEDtuqKWEAARRkmiEaUcAgthxQy0lBCCIkkQjTDsCEMSOG2opIQBBlCQaYdoRgCB23FBLCQEIoiTRCNOOAASx44ZaSghAECWJRph2BCCIHTfUUkIAgihJNMK0IwBB7LihlhICEERJohGmHQEIYscNtZQQgCBKEo0w7QhAEDtuqKWEAARRkmiEaUcAgthxQy0lBCCIkkQjTDsCEMSOG2opIQBBlCQaYdoRgCB23FBLCQEIoiTRCNOOAASx44ZaSgg0Lsj6MNgn5h0lvBGmAQEhORGi3agfhgbVKi3aqCDrw2CPmL+qNCIcrFUEhCSc9sONpoJqVJDeKDhh4s+aCh7n9YNAvCo/iXbD0yZa27Qgx0x8p4nAcU5PCAidTQbjtaZa26gg3W+CbqfDITHdagoAzus2gZjkXtQPD5tqZaOCJEF394M1ekWbHaKgKQg4r5METuOYjqMHYdRk6xoXpMngcW4QKCIAQYoI4XPVBCCI6vQj+CICEKSIED5XTQCCqE4/gi8iAEGKCOFz1QQgiOr0I/giAhCkiBA+V00AgqhOP4IvIgBBigjhc9UEIIjq9CP4IgIQpIgQPldNAIKoTj+CLyIAQYoI4XPVBCCI6vQj+CICEKSIED5XTQCCqE4/gi8iAEGKCOFz1QRaKUjyrjut8CeqM7v04OWsyf2r6grXe0G6oyDoMN0RoU0iCpi4sR0w6kqSb8dNNnxjoTDu0El0P3zqW/tn2+utIN1hcJeZdpgYmz043AOF5JSZDuIf0aOm9ra6Dh7vBOl+G2xyTI+ZuXudwFF3uQQuRJncDx8u98zXO5s3giTbA3Ve0z4Rb18vZNRukkCylagQJXtdNbbfrkn8XgiS3HTzCh3hcsokte6WTUaT802pG9sQriwd5wVJbsKZ6FnhzbfQmZAcM1EUM0WU/MPf8gjEtJZu/se0JsRbTFQ4i9j0roll4DgtSHJZxa9ovOh+Q0j+KkIH0SA8LhMwyiyHQDq7SLRNxF8uOmMs8oXLuXNakN4oSEaOZPr2yp8QvRCW7eh+eLKclOMsNgTOL48P8jYpTy+33tJG01uM5sXmrCCLfjskHTVWacvHaUObTtaGOgX5bPQ3QBbxdVKQdNf3FZ5mjhwiT6aDEDNZHlrTHQXbHeLHmU0X2Z0MwgPXwnJSkN4wOGTmu/OwROi53JBNjByudaPy7VkfBQdZ9yXppdYq9VzLrXOC5I4eQmfxDem6BrB810DJCwJ5vyzm4qyWc4LkXquKPJwMwj10M/8JJE9DdISfXblCaPj3CLPIOidIbxhMr0zrYvTw34q5CPIuo2OSDZdW2Z0SJO/ySnBj3jpBusNgq8N8dHX+3q2bdbcEyYHm+mJS63rvkgJaH26czv8+pZA8nfbDrSU1ofA0TgmSd/8x6Y+damchVRQoRSDrZj1Z45r2w8zF4VIHrbiQUx0vcwqw4Z8Brpg3DjdDIG/K16UvRKcE8eEbBT28OgI+XDFAkOryjSMZEoAghsAwghgC87w4BDFMIAQxBOZ5cQhimEAIYgjM8+IQxDCBEMQQmOfFIYhhAiGIITDPi0MQwwRCEENgnheHIIYJhCCGwDwvDkEMEwhBDIF5XhyCGCYQghgC87w4BDFMIAQxBOZ5cQhimEAIYgjM8+IQxDCBEMQQmOfFIYhhAiGIITDPi0MQwwRCEENgnheHIIYJhCCGwDwvDkEMEwhBDIF5XhyCGCYQghgC87w4BDFMIAQxBOZ5cQhimEAIYgjM8+IQxDCBEMQQmOfFIYhhAiGIITDPi0MQwwRCEENgnheHIIYJhCCGwDwvDkEMEwhBDIF5XhyCGCYQghgC87w4BDFMIAQxBOZ5cQhimEAIYgjM8+IQxDCBEMQQmOfFIYhhAiGIITDPi0MQwwRCEENgnheHIIYJhCCGwDwvDkEMEwhBDIF5XhyCGCYQghgC87w4BDFMYG8UHDPxndlqIhJNB2HP8FAo7gEBCGKYJB+AGYaE4gsIZF8x0Itpf9x1BZxTv1G4Pgx2iHl/Hk5MshH1w9AVaGhHNQR6w2DKzJdkwM9AL2DbHQVBh3h8pYjI7mQQHlSTFhzFBQILcv1wMgj3XGhj0ganRpCkQevDjVNiunXpPoQknPbDDVegoR3XJ5B3OR2zfB7dD0+uf4ZqjuCcIL1hcMjMd69cZol8EQ3C42rCxlGaJNDdD9b4NU2ZeO1SO4TOJoPx5f9rsqEujiDdb4PNjvCzeS6YzWq4p1R4+rzRg0geTfrhToWnuvahnBtBkoh6o42IiT65Gp17AK+dAWUHyPsCTDDEb6UXPQgjl5A4KUh3GGx1mI+yQMUk96J+eOgSRLSlHIHuN0GXV2h85dKKiETkyXQQbpc70vJKOSnIu1EkOGHizyDJ8jpDnWdKZq1Y6Gh+Wjc9p9BZfEO60W54WmcbbI7trCDJt02nw+H8jNaHIOUwXqVdF6HaJKLNdbqjYJuJ9rNGjvTSyuGrAmcFScAtutRKv3hEIiHaiwbhkzZ3MF9jS+43WOgrJt7Mi8HVS6uL9jotSCrJKNjuED9e1EkSUZjpJGY6pjf03LUbPV87uGm7k+lbes23OyybIrTFxEFB3py875hts/OClJXENJko3ywB10cOb0aQi4am04MxH+ffkzSbcJzdgICIU4+TLGq5FyPIe0nercAezj8Sb5AaFG2QgAg9l47suPQoSREOrwSZHU1YaC9vGrgoaHy+XAJC9EJI9nxcv/JSkPeiJFPBK7QjwpvMdHu5acfZFhIQOhOSYyE69vkZOq8FmU1QOoPyhoJOTMnMiVMPvGlSKe7QCQmdtuX9ndYIoqkTItblEYAgy2ONM3lIAIJ4mDQ0eXkEIMjyWONMHhJorSDpO89C6ZuJMdOTttw0utDH3j1SQnc7Qpsx00nUDx+50K462tBKQc4fkjuafXoUO6NU1316o+DZ5QcQ5XDSD+9VdwZ3jtRKQTI3oMPGD5X0utytmRx8G7CKgNUIksLy6BmgKpJb9TFyN1tw9HXZKuJvpSB575EIyam8pQ08Dm/XddaHwRExb83Xdm2zN7vosmu1UpAk1KzLrHQQITmZ9sPPq4So4VgLN1to8c6XrRVk0Su7MfbYMnI6vbR6RePs98n9eXTdKOjzwq0VJIkv74YyvdRapR7eZy/XZfL2sUqf0l2VoM0cWy1Ieqk13Aizn/TFHltl9MjdQzddX3Jrm9Ay8ZiWab0g2hNs2iHmy19d83hXQkieTvvhlRv2657PtfqtFyS91BoFB0T8ZcbsCzbFXtAj8y5RXd7HqmrBVAjybv6ew8ztTLE2ktmnFq15kKKfo1AhSNIDsDZi9t2qcc0ji5AaQbA2Ul4QrWse6gXB2kixJJrXPNQLgrWRYkE0r3lAkHMCWBvJFgVT4le5qLoHuQgfHSFbEO1rHhhBZghgbeRyd8CaR/aXhsoRJJ32xdrI+x6BNY/8ezO1gmBt5EOnwJoHBMkloP29Eax5LJ7ZUz2CpKPIgp96a/t7I1jzKJ72Vi+I5rURrHlAkGICStdGMNVdrmtgBDnnpK3DYM0DgpQjoHBtBGse5bsGRpAZVhrWRrDmUV6OpCQEmePV9vdGsOYBQcwIZJRu69oI1jzMuwZGkAxmbVwbwZqHuRy4xFrArG17amHNA4LYEVhQqy3vjWibwq6yI9R2ifXx17/+6Y2Vm78l5t8QUfLvZpUNX8axhOTHTPxp5rmYnie/5rqMdlRwjtuzv5Xy4XjyXyH6VwXHX/ohWCgWln++kc6ffhiM/1NXA2oRZH0U/IqE/0ZMt+pqOI5bjoDkTVXmflDuuK6UEpFoOgh7dbWnJkE2viOiP9bVaBy3PAERIeZa0ly+ETWXFKE708H4+zpOUwu53ij4CxP/ro4G45iGBDJGCiEhbtES2FuO//Di/vMjQzKlitciyPoweEDMX5dqAQrVTGDOkJZcWs1A+2HSH/+iLoi1CPLzvU8/uvlR/Gcm+j2JvBSmf9QVwDKPy0S/FOKfMcnLmOQFE79c5vltz3XRbmL5n5D8m8WPdi+KN71JJ/r7G+ID727SbROJeiDgGoFaRhDXgkR7QMCWAASxJYd6KghAEBVpRpC2BCCILTnUU0EAgqhIM4K0JQBBbMmhngoCEERFmhGkLQEIYksO9VQQgCAq0owgbQlAEFtyqKeCAARRkWYEaUsAgtiSQz0VBCCIijQjSFsCEMSWHOqpIABBVKQZQdoSgCC25FBPBQEIoiLNCNKWAASxJYd6KghAEBVpRpC2BCCILTnUU0EAgqhIM4K0JQBBbMmhngoCEERFmhGkLQEIYksO9VQQgCAq0owgbQlAEFtyqKeCAARRkWYEaUsAgtiSQz0VBCCIijQjSFsC/wfPNxQj0aXVNgAAAABJRU5ErkJggg==);display:inline-block;background-size:100%}'
       + '.bshare-custom a{margin:0 10px}'
       + '.mask-transparent{display:inline-block;vertical-align:middle;background:transparent;cursor:pointer;margin:0;padding:0;position:absolute;top:0;right:0;bottom:0;left:0;height:100%}',
    weibo = 'http://service.weibo.com/share/share.php?url=' + location.href + '&title=' + document.title,
    douban = 'http://shuo.douban.com/!service/share?href=' + location.href + '&name=' + document.title,
    qq = 'http://connect.qq.com/widget/shareqq/index.html?url=' + location.href + '&title=' + document.title,
    wechat = 'https://api.addthis.com/oexchange/0.8/forward/wechat/offer?url=' + location.href + '&title=' + document.title;

  loadCssCode(indexCss, 'videojsplugin_zving');

  // closest polyfill https://developer.mozilla.org/zh-CN/docs/Web/API/Element/closest#Polyfill
  if (!Element.prototype.matches)
    Element.prototype.matches = Element.prototype.msMatchesSelector ||
      Element.prototype.webkitMatchesSelector;

  if (!Element.prototype.closest)
    Element.prototype.closest = function (s) {
      var el = this;
      if (!document.documentElement.contains(el)) return null;
      do {
        if (el.matches(s)) return el;
        el = el.parentElement;
      } while (el !== null);
      return null;
    };

  registerPlugin('zvingAds', function (options) {
    var
      player = this,
      interval = 0,
      videoDom = document.getElementById(player.id_),
      state = {},
      playPreroll = true,

      requestAds = function () {
        state = {};
        if (player.played().length === 0) {
          player.trigger('adsready');
        }
      },

      playAd = function () {
        if (options && options.plugin4zcms_ADConfig && options.plugin4zcms_ADConfig.frontvideo && options.plugin4zcms_ADConfig.frontvideo.path) {
          state.inventory = options.plugin4zcms_ADConfig.frontvideo.path;
        }
        if (!state.inventory || state.inventory.length === 0) {
          videojs.log('No inventory to play.');
          return;
        }

        player.on('ads-ad-started', function (e) {
          var
            media = videoDom.querySelector('video'),
            mask = videoDom.querySelector('.mask-transparent'),
            control = videoDom.querySelector('.ad-control');

          if (!control)
            videoDom.insertAdjacentHTML('beforeend', '<div class="ad-control">广告还有<span></span>秒</div>');
          media.addEventListener('loadedmetadata', function () {
            if (media.src.indexOf(state.inventory) !== -1) {
              var duration = Math.ceil(media.duration);
              interval = setInterval(function () {
                var t = Math.ceil(duration - media.currentTime);
                videoDom.querySelector('.ad-control span').innerText = t;
              }, 250);
            }
          });

          if (!mask) {
            if (options && options.plugin4zcms_ADConfig && options.plugin4zcms_ADConfig.frontvideo && options.plugin4zcms_ADConfig.frontvideo.link) {
              videoDom.insertAdjacentHTML('beforeend', '<a class="mask-transparent" href="' + options.plugin4zcms_ADConfig.frontvideo.link + '" target="_blank"></a>');
            }
            mask = videoDom.querySelector('.mask-transparent');
          }

          videoDom.querySelector('.vjs-control-bar').style.display = 'none';
        });

        player.on('ads-ad-ended', function () {
          clearInterval(interval);
          videoDom.querySelector('.mask-transparent').style.display = 'none';
          videoDom.querySelector('.ad-control').style.display = 'none';
          videoDom.querySelector('.vjs-control-bar').style.display = '';
        });

        player.ads.startLinearAdMode();
        state.adPlaying = true;

        var media = state.inventory;
        player.src(media);
        player.trigger('ads-ad-started');

        player.one('adended', function () {
          player.trigger('ads-ad-ended');
          player.ads.endLinearAdMode();
          state.adPlaying = false;
        });
      };

    player.appendSwfObject = function (front) {
      var content = "\n         <object class=\"swf\"\n          type=\"application/x-shockwave-flash\" \n          data=\"".concat(front.path, "\" \n          data_url=\"").concat(front.link, "\"\n          width=\"").concat(front.width, "\" height=\"").concat(front.height, "\">\n            <param name=\"allowfullscreen\" value=\"true\">\n            <param name=\"allowscriptaccess\" value=\"always\">\n            <param name=\"seamlesstabbing\" value=\"true\">\n            <param name=\"wmode\" value=\"direct\">\n            <param name=\"menu\" value=\"false\">\n          </object>\n          <div class=\"close-content\" title=\"\u5173\u95ED\">\n              <div class=\"close\"></div>\n          </div>\n    ");
      var adcontent = "<div class=\"ad-content\" data_url=\"".concat(front.link, "\">\n          ").concat(content, "\n        </div>\n        <a class=\"ad-click\" target='_blank' href='" + front.link + "'></a>");
      var contentDom = videoDom.querySelector('.ad-content');
      if (!contentDom) {
        videoDom.insertAdjacentHTML('beforeend', adcontent);
      } else {
        contentDom.innerHTML = content;
        contentDom.setAttribute('data_url', front.link);
        if (!videoDom.querySelector('.ad-click')) {
          videoDom.insertAdjacentHTML('beforeend', '<a class="ad-click" target="_blank" href="' + front.link + '"></a>');
        }
      }
    };

    player.updateSwfObject = function (front) {
      var contentDom = videoDom.querySelector('.ad-content');
      var adClickDom = videoDom.querySelector('.ad-click');
      var swf = contentDom.querySelector('object');
      contentDom.style.display = '';
      adClickDom.style.display = '';
      swf.setAttribute('data', front.path);
      swf.setAttribute('data_url', front.link);
      swf.setAttribute('width', front.width);
      swf.setAttribute('height', front.height);
    };

    player.updateVideo = function (front) {
      var contentDom = videoDom.querySelector('.ad-content');
      var adClickDom = videoDom.querySelector('.ad-click');
      var video = contentDom.querySelector('video');
      contentDom.style.display = '';
      adClickDom.style.display = '';
      contentDom.setAttribute('data_url', front.link);
      video.setAttribute('src', front.path);
      video.setAttribute('width', front.width);
      video.setAttribute('height', front.height);
      video.setAttribute('autoplay', 'autoplay');
      video.setAttribute('loop', 'loop');
    };

    player.appendVideo = function (front) {
      var content = "\n<video autoplay=\"autoplay\" loop=\"loop\" src=\"".concat(front.path, "\" alt=\"\" width=\"").concat(front.width, "\" height=\"").concat(front.height, "\"></video>\n        <div class=\"close-content\" title=\"\u5173\u95ED\">\n              </span><div class=\"close\"></div>\n        </div>\n    ");
      var adcontent = "<div class=\"ad-content swf\" data_url=\"".concat(front.link, "\">\n        ").concat(content, "\n      </div>\n      <a class=\"ad-click\" target='_blank' href='" + front.link + "'></a>");
      var contentDom = videoDom.querySelector('.ad-content');
      if (!contentDom) {
        videoDom.insertAdjacentHTML('beforeend', adcontent);
      } else {
        contentDom.innerHTML = content;
        contentDom.setAttribute('data_url', front.link);
        if (!videoDom.querySelector('.ad-click')) {
          videoDom.insertAdjacentHTML('beforeend', '<a class="ad-click" target="_blank" href="' + front.link + '"></a>');
        }
      }
    };

    player.updateImage = function (front) {
      var contentDom = videoDom.querySelector('.ad-content');
      var adClickDom = videoDom.querySelector('.ad-click');
      var img = contentDom.querySelector('img');
      contentDom.style.display = '';
      adClickDom.style.display = '';
      contentDom.setAttribute('data_url', front.link);
      img.setAttribute('src', front.path);
      img.setAttribute('width', front.width);
      img.setAttribute('height', front.height);
    };

    player.appendImage = function (front) {
      var content = "\n<img src=\"".concat(front.path, "\" alt=\"\" width=\"").concat(front.width, "\" height=\"").concat(front.height, "\">\n        <div class=\"close-content\" title=\"\u5173\u95ED\">\n              <div class=\"close\"></div>\n        </div>\n    ");
      var adcontent = "<div class=\"ad-content swf\" data_url=\"".concat(front.link, "\">\n        ").concat(content, "\n      </div>\n      <a class=\"ad-click\" target='_blank' href='" + front.link + "'></a>");
      var contentDom = videoDom.querySelector('.ad-content');
      if (!contentDom) {
        videoDom.insertAdjacentHTML('beforeend', adcontent);
      } else {
        contentDom.innerHTML = content;
        contentDom.setAttribute('data_url', front.link);
        if (!videoDom.querySelector('.ad-click')) {
          videoDom.insertAdjacentHTML('beforeend', '<a class="ad-click" target="_blank" href="' + front.link + '"></a>');
        }
      }
    };

    player.reactAdClick = function () {
      var contentDom = videoDom.querySelector('.ad-content');
      if (contentDom.style.display === 'none') {
        contentDom.style.display = '';
      }
      if (contentDom) {
        var clickDom = videoDom.querySelector('.ad-click');
        clickDom.style.cssText = 'position: "absolute";width: ' + contentDom.offsetWidth + 'px;height: ' + contentDom.offsetHeight + 'px;z-index: 2';
      }
    };

    player.setRecommendConfig = function (opt) {
      if (!options) {
        options = {};
      }
      options.recommendConfig = opt;
    };

    player.setPlugin4zcms_ADConfig = function (opt) {
      if (!options) {
        options = {};
      }
      options.plugin4zcms_ADConfig = opt;
    };

    player.addClass('videojs-zving');
    // logo水印
    // videoDom.insertAdjacentHTML('beforeend', '<a href="http://www.zving.com" target="_blank" class="logo"><img src="files/playerLogo.png" alt=""></a>');
    player.on('adsready', function () {
      if (!playPreroll) {
        player.trigger('nopreroll');
      }
    });

    player.on('contentchanged', function () {
      requestAds();
    });

    player.on('readyforpreroll', function () {
      if (!state.prerollPlayed && playPreroll) {
        state.prerollPlayed = true;
        playAd();
      }
    });

    player.ready(function () {
      var that = this;
      // 前置广告
      this.check = setInterval(function () {
        if (options && options.plugin4zcms_ADConfig && options.plugin4zcms_ADConfig.front) {
          that.check = clearInterval(that.check);
          var front = options.plugin4zcms_ADConfig.front;
          var path = front.path;
          if (/\.swf$/.test(path)) {
            that.appendSwfObject(front);
            that.frontType = 'flash';
            if (isFlash()) {
              that.reactAdClick();
            }
          }

          if (/\.(png|gif|jpg)$/.test(path)) {
            that.appendImage(front);
            that.frontType = 'img';
            that.reactAdClick();
          }
        }
      }, 500);

      this.on('play', function () {
        if (player.check) {
          clearTimeout(player.check);
        }
        this.bigPlayButton.hide();
        var adcontent = videoDom.querySelector('.ad-content');
        var adclick = videoDom.querySelector('.ad-click');
        if (adcontent)
          adcontent.style.display = 'none';
        if (adclick)
          adclick.style.display = 'none';
      });

      this.on('pause', function () {
        if (!this.ended()) {
          if (options && options.plugin4zcms_ADConfig && options.plugin4zcms_ADConfig.pause) {
            var pause = options.plugin4zcms_ADConfig.pause;
            var path = pause.path;

            if (/\.swf$/.test(path) && that.frontType == 'flash') {
              this.updateSwfObject(pause);
              if (isFlash()) {
                this.reactAdClick();
              }
            }

            if (/\.swf$/.test(path) && (that.frontType == 'img' || !that.frontType)) {
              if (videoDom.querySelector('.ad-content object')) {
                this.updateSwfObject(pause);
              } else {
                this.appendSwfObject(pause);
              }
              if (isFlash()) {
                this.reactAdClick();
              }
            }

            if (/\.mp4$/.test(path) && that.frontType == 'video') {
              this.updateVideo(pause);
              this.reactAdClick();
            }

            if (/\.mp4$/.test(path) && (that.frontType == 'flash' || !that.frontType)) {
              if (videoDom.querySelector('.ad-content video')) {
                this.updateVideo(pause);
              } else {
                this.appendVideo(pause);
              }
              this.reactAdClick();
            }

            if (/\.(png|gif|jpg)$/.test(path) && that.frontType == 'img') {
              this.updateImage(pause);
              this.reactAdClick();
            }

            if (/\.(png|gif|jpg)$/.test(path) && (that.frontType == 'flash' || !that.frontType)) {
              if (videoDom.querySelector('.ad-content img')) {
                this.updateImage(pause);
              } else {
                this.appendImage(pause);
              }
              this.reactAdClick();
            }
            videoDom.querySelector('.ad-content').style.display = '';
          }
          this.bigPlayButton.show();
        } else {
          this.bigPlayButton.hide();
        }
      });

      this.on('ended', function () {
        var video = videoDom.querySelector('video');
        if (video && video.src.indexOf(state.inventory) === -1) {
          if (options && options.recommendConfig) {
            if (!videoDom.querySelector('.zving-mask-ed'))
              videoDom.insertAdjacentHTML('beforeend', "\n<div class=\"zving-mask-ed\">\n<div><div class=\"replay\">\n<img src=\"data:image/png;base64,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\" alt=\"\">\n  <span>\u91CD\u64AD</span>\n</div><div class='share'><img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAMgAAADICAYAAACtWK6eAAAQ4ElEQVR4Xu1dQXbUOBOWmuneDpxgwgmAE0w4wR9OQLJo+bGCnIBwAsKKZ2dBOMGEE0znBGROQHKCP7OFuDWvQD30QLptyyq5ZH1+L6tYUtVX9XVZUqmkFR4gAAQ2IqCBDRAAApsRAEHgHUBgCwIgCNwDCIAg8AEg4IcAIogfbmiVCQIgSCaGhpp+CIAgfrihVSYIgCCZGBpq+iEAgvjhhlaZIACCZGJoqOmHAAjihxtaZYIACJKJoWOo+fbt2507d+78tj5WXddXz549u4wxPscYIAgHqhn0WVXV71rrXWst/e1orXe2qW2tvdRa09/CWrswxpynABMIkoKVhMh4cnJCZHiqlNpTSt3tKda1UupMa302n88/9OyLrTkIwgbteDouy5JIcdQUJXw1puhC/RdF8d63D652IAgXsiPotyxLihSvuYjxI0QSiQKCjMCRQ6vgJtvvlFK7oftu2d+irusDCZN7EKSlxXJ5jaKG1prI0XeO0RcymqMcGmNO+3bUpz0I0ge9kbU9OTl5aa09EqbWqTHmYCiZQJChkBc2blVVFDX2hYm1EmcwkoAgQj0ipljCyfEVCmvtWVEUT2LiQmOBILERFzZeCuRYgyx6JAFBhDlsTHGqqqJPKvq0Suax1r4qiiLaPAkEScY1wgpaVdVDpdTHsL3G6U1r/Xg+ny9ijAaCxEBZ4BhlWX6KtQHIoP71dDq9f3BwQEvBrA8IwgqvzM7LsqS0kZcypWst1RtjzIvWb3u+CIJ4ApdqM7dL/ilV+X+Q+5Ex5oJTFxCEE12BfZdleaq1puTD5B9r7fuiKFj3bkCQ5N2kvQIjix5fFa/r+j5nzhYI0t6/kn9zJHOP/9iBO4qAIMm7fXsFEl+52qTotTHmXnsUur0JgnTDK9m3U973aAH6AVfWLwjSAv0xvDLGz6uVXTg/s0CQMXh/Cx2qqqJdc9o9H91DJxGLorjPoRgIwoGqwD6rqrICxQom0nQ6vcexsw6CBDOR3I5GPv/4CjxXfhYIItevg0nmjtH+EaxDgR1Zaw+LojgOLRoIEhpRgf2NeYK+NlFnSYMHQQQ6dGiRQBB/REEQf+ySaZkJQVjyskCQZNzcX9AcCKKUOjfGBK/jBYL4+10yLXMgCNdRXBAkGTf3FxQE8ccOBPHHLpmWrir7n8kI7CEoIogHaGjyDYEcNgqttU+KojgLbXNEkNCICu1v7KkmSimW47cgiFCHDi1WVVVUJuf30P1K6c8Yw+LLLJ1KAQ1yfENAaFHqkOZhWeIlAUGQkGYS1hdNzpfL5buE61+1QpRrgg6CtII/vZfevXt39/Pnzy+11ux1oySgw1m4ARFEgoUDypBL1FhBZq39qygKtoNgIEhA5xyyK4oaX758eS34jg8ueNjOo+MTi8tkkfsVdG1aZM3VlTFm6/3sfQVCBOmL4IDt3VyDJuF0G212D9chqXUgQZBE3SrjqLGyGHv0wCdWguQQcEWzCNS4zqD/qBwiiAhztxOiqqrnSim6XWnoK5rbCcz0FmcdLBCEyWic3SJqfEeXlnVns9kuR4mf22yICMLp2QH6dmkitOGXddQgKK21f2utd7nvBMEkPYDjcnfhUtTpgk22TTBuHUL2PwQ5MEkPacGAfcVKLiSnozmN1nphrV1orX8NqEawrpyc+xznPZqExCdWE0IR/+9O/tFueIyocV7X9f7q8hmKWNZaun3qQUSVG4caKnKsBANBGk3E/0LM5MJV1LitCqFLV6FTeSLOjdCEXGu9H3POgVUsfn/vNELk5MIPdV2/aLqyTEKRB1rKnc1mL2KtVm0yGiJIJ3cO9/IAUaPTN7xbJKBat7GjyRVFjfl8TicgB39AkAFMQGkiSqnXkQ4yfZhOp/u+v8RVVdEtsrQ5+RszVFfW2mOOAtR95AZB+qDXsW3M5MLQKz+OKETs/3VUe+vrbp5xzHWFWl9ZQZC+CLZsHzm58M10Oj3yjRrbVKJd/clkskcbdj3Ick7Lysvl8rRpPtQSXrbXQBA2aL917ByKPqdipKRH/353S9M71todrTUtT/+04+/2WC611pdS5hZtzQ6CtEXK473IyYVsUcND9dE0AUEYTBkzuZC+4SeTyYvUfpkZYGfpEgQJDGvMqMFZ7iYwLMl2NwqCuDV7NeSOa8zkQgk7zMl6fEfBkyGIc0DatKKJIB3U33ZZyrVS6kIpdelWS845V0tiJReSbRE1Onp4z9dFE8Ql0D2lndW+5yHosnml1NlyuXwTiiwxowbdoLSeXNjT7mjeEgGRBCnLckWK4FdqOVwotfuV78SWNvxubm6eW2tph5n12ZZcyDowOv+KgCiCRE7cI/0p3+ewy9wlsoyIGgMTVQRBYqZg3IY35QDNZrNX23aeYycXUl1dqekXA/ts1OEHJ0jkFIyN4NIcRWv95LZoEjlq9EoujOo9GQw2KEFirv50sOW/tV5jRrbQyYUd9MWrWxAYjCBVVVFBAlqdEvdorY+WyyWdZiMZ2auJSDkcJM4QAgQahCCSyRHZJtGTCyPrl/xw0QkCcvzrM0guTIA+UQlSluULrTVV7cj5QdRIyPrRCJLDXd1Ndqc0kdlsdsxxkKlpbPzfD4EoBHGrQR8jncH2Q4KxFZILGcFl7joKQSSUkWHGcdv+yquiKNhTUobSb+zjshPEHR76NHYgb9HvXClFu+GUVYwnUQTYCVKWJZWzfJooPp3FRnJhZ8hEN2AlSIbRA8mFot29u3CsBMkleiBqdHe8VFqwEqSqqv/HSNUYGOxW9W4HlhHDeyLARhCXpfuHp1zimyG5ULyJggjISZAxT87Pp9PpHjb8gvig6E44CfJpxBuDb4wxdG8gnpEjwEKQDFavLowxj0buG1CP60y6q9f655gRNsaw/LiMGbMUdWMxcg5Zu1rrx75VUVJ0lFxl5iII3Zz6csyggiBjtu533UAQTztbaw+l3YbkqQqabUGAhSBVVdFNqUFvIpJmRZQAlWYRHnm4CEIF2WJf/siD0IZeQZCocA82GAtBcsjBAkEG89moA3MRZPSTdBAkqp8ONhgI4gk9VrE8gUusGQtB3JXBVHRtzM8jnBYcs3m/6cZCEOykj99xctGQhSAEXlVVdqwgUqHroijuj1U/6PUdATaClGV5obV+MGKwF3VdH4S6rWrEOCWtGidBRr+SpZS6ttYeFEVBG6N4RogAG0FyqqTY5gKeEfpOFiqxEcTNQ+jizN+yQPLbrbp0twjqYI3I4KwEySHt/QdfoOunj4wxb0bkI1mrwkoQV5OXrjb7NSeUrbVns9nsAGfW07c6K0EInozr8l7TnYc4VJU2SdgJkmsUWbkFXec2n89fpe0m+UrPThAXRfa01qOtkdXCfS7qun6CPZMWSAl7JQpB3IrW6A9RNdgWeybCnL+NONEIQp9aX758oSXQXJZ9N+F/Op1ODzGBb+Oew78TjSAuijy01i5yW9X60cyUy0UTeOyZDE+AJgmiEsSRhO5GF58KT7V3tdYU8TiPDtMFO9gzafLSAf8fnSApkMSRY5d+4SMsUy+m0+kTfHINyIItQw9CkBVJKIdJ4OfWlVJqb/3zx+WV0SID1/wJeyYy+cFzYKqtruR4wuYkG6u2u/0cIjTbdXL0g1EUxWFb/PAePwKDRZCVam5163ToOlptizDQcWLmyIekR36/bz3C4ARZSRrB8W4FxecOc6peP5lMzhgPhFHS46Exhn448AyIgBiCEAbuM4bu3XgRYW5Ccw3KvPV2wqqqjpVSz7nsh6RHLmTb9yuKIOufXZ8/fyaS0JJw0ImxixjHfYixDi8VqFgulxRNWDKWsWfS3pk53hRJkFsccF9rvetLFkcKKod6yrE55+ZRtMrFtmeCpEcO92/uUzxB1lVw3/4PlVL0t7Ppijf61VVKXU4mk8Uvv/xyEWuPIcIBMXGFItxK5IPJZLKzXC7vaq3JNv95tNYLay3Nqy6m0+lfsezR7P7NbyRFkGZ1hn/DOQxdYMpV0WXQpEd3vR5V7t9TSlFU93ko3Whxc3PzXnqGMwjiY96GNrH2TGaz2atYv8ZlWT51c0JfUmxC7cLt/7xnMEXvLkGQ3hBu7oDuiqd5D9cEnj5ZuAtFEDFotS/CjcWUTXAs7XAZCMJIEOo60p5J8EIRLr3mdY/PKC9kaf44mUwOpBxVBkG8zNi9EXfSY8g9k5OTk5fW2qPuWgZtIeLcDAgS1KbbO3NFvWljMujeztqovZIe3XI1HY0OPc/wRZn9E7JJMBCkCaHA/4+Re+azZ+JWp4gcPy3TBoaga3e0PPyYY/+qjSAgSBuUGN6hPRM3+WXZgacJfNtCEW6+8adS6i6DqqG6pKqV3mlBvkKAIL7IBWgnYc/ELUl/jLBK1RexQSIJCNLXbD3bu08umhCzJT3SUvNthSLc2BQ5pH1WbUI1OklAkJ4OHqr5EHsmZVn+obWmvZqUHkpXeRxrgxQEEeQabqJM39lsSY90lIAKRSR+jyQlnR7EMB0IEgPljmNw75kopSizmT6rJE/Kt6IW65ZhEKSj88Z6PUKhiFiqsIxDO+6z2ewR96cWCMJivjCdxtgzCSPpML20rSPQRzoQpA96kdoOdV4/knp9hrk2xtzr00FTWxCkCSEh/4+wZyJE085isG4ggiCd7TFsA+5CEcNq5zX6hTHmkVfLFo1AkBYgSXuFu1CENH2b5Knr+j7XyUQQpAl9of+PUShCqOo/icU5WQdBUvGCDXJGKBSRAkLnxhiWFH0QJAXzN8iIPROljDEsvszS6Qh8LjkVYhSKkAwK1846CCLZ6h6y5bpnYq19UhQFFe8L+oAgQeGU0VmEQhEyFF2TgmuiDoKIM3U4gSIkPYYTtmdPIEhPAHNtntGeyRtjDB1jDvogggSFU2ZnmUQSlqVeEESmTweVKhOCfDDGBD8dCYIEdUWZneVAEMxBZPpeElKBIP5mQgTxxy6Zlq6iI1UvGe1jrT0sioKuxAv6gCBB4ZTZmUtF+ShTujBSYSc9DI7Z9lJVlR2z8lwp74ggY/aaNd2qqqJKJpzlhIZE8soYs8MhAAjCgarAPsc8UbfWvi+Kgm5EDv6AIMEhldnhyOchbOfSQRCZ/swiVVVVdPsv190kLDI3dWqt/bsoCrYCeCBIkwVG9P8xfmZxfl6R6UGQERGgSRVX+/dT03sp/Z9r9WqFAQiSkjcEkLUsS7p1l26uTf7hjh6IIMm7SHcF3GGqC8arqbsL5d/iEffVbIgg/sZJtuVI5iIs5z9+NCoIkqyb9xO8LEuKIg/69TJMa1q5ms1mO9yV3fGJNYx9RYzqav0uUvzU4sq7us0wiCAi3HUYIVK8ZYrr3McmC4Agw/immFFTWtWKsWqFOYgY15QjSCIkYTlS22QFRJAmhDL5v2SSDBE5VmYHQTIhQBs1JRbCHpIcWMVq4zWZvSOljhYt5Wqt6cpquhZ7sAcRZDDo5Q4s4PLQ87qu97kuxemCPAjSBa3M3nXFHugXPFaK/JVS6mjoqLFuZhAkM6f3UdftlxwxEkUcMTBJ9/GUzNu43Xeqf7vXdwee5hhKKbqu4Izj2oJQpkIECYVkZv04shBRdq21d1vkdVGUuLTWLiaTyWI+n1MRCfEPCCLeROkISJP7m5ubh+sS39zcXEqYbPuiCIL4Iod2WSAAgmRhZijpiwAI4osc2mWBAAiShZmhpC8CIIgvcmiXBQIgSBZmhpK+CIAgvsihXRYIgCBZmBlK+iIAgvgih3ZZIACCZGFmKOmLAAjiixzaZYEACJKFmaGkLwL/AImuJTKpMR8oAAAAAElFTkSuQmCC'><span>分享</span></div></div>\n<div class=\"play-list\">\n".concat(showRecommend(options.recommendConfig), "\n  </div>\n</div>\n  "));
            videoDom.querySelector('.zving-mask-ed').style.display = '';
            if (options.plugin4zcms_ADConfig && !options.plugin4zcms_ADConfig.share) {
              videoDom.querySelector('.share').style.display = 'none';
            }
          }

          if (!document.querySelector('.shareWrap') && options && options.plugin4zcms_ADConfig && options.plugin4zcms_ADConfig.share) {
            document.body.insertAdjacentHTML('beforeend', '<div class="shareWrap" style="display: none;">\n' +
              '  <div class="shareTitle">\n' +
              '    <div class="shareClose"></div>\n' +
              '    分享\n' +
              '  </div>\n' +
              '  <div class="shareCon">\n' +
              '    <div class="share"><strong>一键转帖</strong>\n' +
              '      <div class="bshare-custom"><a title="分享到新浪微博" href="' + weibo + '" target="_blank" class="bshare-sinaminiblog">' +
              '         <a href="' + douban + '" target="_blank" title="分享到豆瓣" class="bshare-douban"></a>' +
              '         <a href="' + wechat + '" target="_blank" title="分享到微信" class="bshare-weixin"></a><a\n' +
              '        title="分享到QQ好友" href="' + qq + '" target="_blank" class="bshare-qqim"></a>\n' +
              '      </div>\n' +
              '    </div>\n' +
              '  </div>\n' +
              '</div>');
          }
        }
      });

      player.ads({
        timeout: 0
      });
      requestAds();

      videoDom.addEventListener('click', function (event) {
        var el = event.target;
        if (el.classList.contains('close-content') || el.closest('.close-content')) {
          videoDom.querySelector('.ad-content').style.display = 'none';
          videoDom.querySelector('.ad-click').style.display = 'none';
        }

        if (el.classList.contains('replay') || el.closest('.replay')) {
          that.play();
          videoDom.querySelector('.zving-mask-ed').style.display = 'none';
          that.controls(true);
          document.querySelector('.shareWrap').style.display = 'none';
        }

        if (el.classList.contains('share') || el.closest('.share')) {
          var shareWrap = document.querySelector('.shareWrap');
          if (shareWrap.style.display === 'none') {
            shareWrap.style.display = '';
          } else {
            shareWrap.style.display = 'none';
          }
        }
      });

      document.addEventListener('click', function (event) {
        var el = event.target;
        if (el.classList.contains('shareClose')) {
          var shareWrap = document.querySelector('.shareWrap');
          shareWrap.style.display = 'none';
        }
      });
    });

    return {
      setRecommendConfig: this.setRecommendConfig,
      setPlugin4zcms_ADConfig: this.setPlugin4zcms_ADConfig
    };
  });

})(window, document, videojs);
