function ZVIDEOGROUP (videoInfo) {
  // 清晰度的视频地址
  this.urlData = videoInfo.urlData
  // 清晰度对应的中文名
  this.nameData = videoInfo.nameData || {}
  // 视频播放器ID
  this.id = videoInfo.id
}
// 添加转换清晰度按钮
ZVIDEOGROUP.prototype.addVideoResolutionMenu = function() {
  var that = this
  var videoPanelMenu = $(".vjs-fullscreen-control");
  if ($('.zv-menu').length) {
    $('.zv-menu').remove()
  }
  var source = this.urlData;
  if (source) {
    var html = '<div class="vjs-subs-caps-button vjs-menu-button vjs-menu-button-popup vjs-control vjs-button zv-menu" aria-live="polite" aria-expanded="false" aria-haspopup="true">'
        + '<div class="vjs-menu" role="presentation">'
        + '<ul class="vjs-menu-content videoResolution" role="menu">'
    for (var k in source) {
      var code = k
      if (k !== 'first') {
        var title = this.getCname(k)
        html += '<li class="vjs-menu-item" tabindex="-1" role="menuitemcheckbox" data-type="'+ code +'">'+ title +'</li>';
      }
    }
    html += '</ul></div>'
          +'  <button class="vjs-subs-caps-button vjs-control vjs-button" type="button" aria-live="polite" title="清晰度切换" aria-disabled="false">'
          +'      <span aria-hidden="true" class="vjs-icon-text">'+ this.getCname(source.first) +'</span>'
          +'  </button>'
          +'</div>'
    videoPanelMenu.before(html);
    this.bind();
  }
}
// 事件绑定
ZVIDEOGROUP.prototype.bind = function() {
  var that = this
  $('.videoResolution li').click(function() {
    that.changeVideo($(this).attr('data-type'))
  })
}
// 事件解绑
ZVIDEOGROUP.prototype.unbind = function() {
  $('.videoResolution li').unbind()
}
// 视频清晰度切换
ZVIDEOGROUP.prototype.changeVideo = function(type) {
  var that = this;
  var id = this.id;
  var src = $('#' + id).find('video').attr('src');
  // 切换的清晰度和现在播放的视频一样不处理
  if (src.indexOf(type) > -1) {
    return
  }
  if (that.urlData[type]) {
    // 当前播放时间点
    var ctime = videojs(id).currentTime();
    // 视频总时长
    var duration = videojs(id).duration();
    // 清晰度名称
    var name = that.getCname(type);
    videojs(id).src(that.urlData[type]);
    videojs(id).load();
    // 如果当前时间点等于总时长重新播放
    if (ctime === duration) {
      videojs(id).reset();
    } else {
      videojs(id).currentTime(ctime);
    }
    $('.vjs-icon-text').text(name);
    videojs(id).play()
  }
}
ZVIDEOGROUP.prototype.init = function(videoResolution) {
  var that = this;
  var id = this.id;
  var src = $('#' + id).find('video').attr('src');
  if (src && src.indexOf(videoResolution) === -1) {
    if (that.urlData[videoResolution]) {
      videojs(id).src(that.urlData[videoResolution]);
      videojs(id).muted(true);
      setTimeout(() => {
        videojs(id).play();
        videojs(id).muted(false);
        // $('.fa-play-circle').show();
        $('.fa-play-circle').click(function() {
          videojs(id).play();
          $('.fa-play-circle').hide();
        })
      }, 1000);
    }
  }
}
// 清晰度中文名
ZVIDEOGROUP.prototype.getCname = function(code) {
  if (this.nameData[code]) {
    return this.nameData[code]
  }
  switch(code) {
    case 'default':
      return '默认'
    case 'smd':
      return '标清'
    case 'hd':
      return '高清'
    case 'spd':
      return '超清'
  }
  return '默认'
}
// 设置清晰度的视频地址
ZVIDEOGROUP.prototype.setUrlData = function(urlData) {
  this.urlData = urlData
}
// 设置清晰度对应的中文名
ZVIDEOGROUP.prototype.setNameData = function(nameData) {
  this.nameData = nameData
}
