;!function(){
  "use strict";
  var CMSArticle = {
    $ele: '',
    init: function(eleID) {
      this.$ele = eleID ? $("#" + eleID) : $("body")
      this.transformAudioTag()
      this.transformVideoTag()
    },
    transformVideoTag:function(){
      var self = this;
      var $videos = this.$ele.find("video")
      if($videos.length > 0) {
        $videos.removeClass("z-cms-video").addClass("video-js")

        if(typeof videojs === 'undefined') {
          loadCSS(Zving.JSLIBPATH + 'video.js/video-js.min.css')
          loadJS(Zving.JSLIBPATH + 'video.js/video.min.js',function(){
            self.renderVideo()
          })
        } else {
          self.renderVideo()
        }
      }
    },
    renderVideo: function(){
      var self = this;
      // 视频播放器居中并设置按钮outline属性为none
      addStyle('.video-js {margin:0 auto;}.video-js button{outline: none;}');
      $.each(self.$ele.find("video"),function(){
        var $this = $(this);
        var videoURL = $this.attr("src")
        if(videoURL.endsWith(".mp4")) {
          $this.append('<source src="' + videoURL + '" type="video/mp4">')
        } else if(videoURL.endsWith(".webm")) {
          $this.append('<source src="' + videoURL + '" type="video/webm">')
        } else if(videoURL.endsWith(".ogg")) {
          $this.append('<source src="' + videoURL + '" type="video/ogg">')
        } else {
          $this.append('<source src="' + videoURL + '">')
        }

        videojs(this, {
          controls: true,
          autoplay: true,
          preload: 'auto'
        });
      })

    },
    transformAudioTag:function(){
      var self = this;
      var $audios = this.$ele.find("audio")
      if($audios.length > 0) {
        if(typeof audiojs === 'undefined') {
          loadJS(Zving.JSLIBPATH + 'audiojs/audio.min.js',function(){
            self.renderAudio()
          })
        } else {
          self.renderAudio()
        }
      }
    },
    renderAudio:function(){
      var self = this;
      audiojs.events.ready(function() {
        var $audios = self.$ele.find("audio")
        var settings = {
          autoplay:$audios.length === 1,
          loop: $audios.length > 0 && $audios.eq(0).prop('loop') === 'loop'
        }
        audiojs.createAll(settings, $audios);
      });
    }
  }
  window._CMSArticle = CMSArticle;
}();
