/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 0);
/******/ })
/************************************************************************/
/******/ ({

/***/ "./siteassets_src/comment/index.js":
/*!*****************************************!*\
  !*** ./siteassets_src/comment/index.js ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/* global $ */
// const Rating = require('../jslib/Rating.js')
var z = window.Zving || {};
z.Member = z.Member || {};
var Member = z.Member;
window.Member = Member;

var cmt_isNeedLogin = false;
var MaxLength = 200;
var elSelector = {
  commentContainer: 'divComment',
  checkStar: 'checkstar',
  checkMood: 'checkMood',

  textarea: 'cmt_content',
  counter: 'cmt_content_count',
  checkbox: 'cmt_CmntCheckbox',
  submitBtn: 'cmtSubmit',
  loginContainer: 'cmt_Login',
  username: 'cmt_uname',
  password: 'cmt_pass',
  authCode: 'cmt_AuthCode',
  authImg: 'cmt_authCodeImg',
  loginBtn: 'cmt_frmbutton',
  commentCount: 'cmt_commtotal',
  personCount: 'cmt_commusertotal',
  registerBtn: 'cmt_reg',
  parent: 'cmt_ParentID',
  score: 'cmt_ContentScore',
  logout: 'cmt_logout',

  replyBox: 'replyBox',
  replyBoxContainer: 'commentLoginBox_reply',
  userNameLabel: 'userNameLabel',
  loginedPanel: 'cmt_Logined', // 登录状态内容显示容器
  logoutPanel: 'cmt_Login', // 未登录状态内容显示容器
  authCodeContainer: 'authCodeContainer',
  loginFrm: 'cmt_frm'
};
var suffix = '_reply';

var getDom = function getDom(el, doc) {
  if (!el) {
    return el;
  }
  if (typeof el === 'string') {
    return (doc || document).getElementById(el.replace(/^#/, ''));
  }
  if (!el.nodeName && el.length && el[0] && el[0].nodeName) {
    // 如果是一个jquery对象
    return el[0];
  }
  return el;
};

$(function () {
  if ($.isEmptyObject(window.localsForComment)) {
    return;
  }

  cmt_isNeedLogin = window.localsForComment.isNeedLogin === true || window.localsForComment.isNeedLogin === 'true';
  // 判断是否显示评论框（没有评论框或过期时，不显示）
  var commentContainer = getDom(elSelector.commentContainer);
  if (!commentContainer) {
    return;
  }
  commentContainer.style.display = 'block';

  Member.initFaceVote();
  Member.initComment(document.body);

  //评论框中交互处理
  //登录，注册事件处理
  var loginBtns = [elSelector.loginBtn, elSelector.loginBtn + suffix];
  loginBtns.forEach(function (id) {
    var el = getDom(id);
    if (!el) {
      return;
    };
    $(el).on('click', Member.commentLogin);
  });
  var registerBtns = [elSelector.registerBtn, elSelector.registerBtn + suffix];
  registerBtns.forEach(function (id) {
    var el = getDom(id);
    if (!el) {
      return;
    };
    $(el).on('click', Member.register);
  });

  var anti = $('.comment-anti');
  anti.attr('href', '#');
  anti.click(function () {
    Member.commentSupport('anti', this);
    return false;
  });

  var support = $('.comment-support');
  support.attr('href', '#');
  support.click(function () {
    Member.commentSupport('support', this);
    return false;
  });

  var reply = $('.comment-reply');
  reply.attr('href', '#');
  reply.click(function () {
    var comment = $(this).parent().next('.comment-reply-div');
    if (comment.length != 0) {
      comment.toggle();
    } else {
      var div = $('.comment-reply-div');
      if (div.length == 0) {
        var html = $('.comment').prop('outerHTML');
        html = "<div class='comment-reply-div bg-light lt'>" + html + '</div>';
        $(this).parent().after(html);
        $(this).parent().next('.comment-reply-div').find('.comment-listlink').parent().hide();
      } else {
        div.detach();
        $(this).parent().after(div);
        div.show();
      }
    }
    return false;
  });
  var showLoginForm = function showLoginForm(reply) {
    var panelId = elSelector.loginPanel,
        authCodeContainerId = elSelector.authCodeContainer,
        frmId = elSelector.loginFrm,
        panelEl,
        authCodeContainerEl,
        frmEl;

    panelEl = getDom(panelId);
    authCodeContainerEl = getDom(authCodeContainerId);
    frmEl = getDom(frmId);

    frmEl.reset();
    $('#' + elSelector.loginedPanel).hide();
    $('#' + elSelector.logoutPanel).show();
    // 隐藏验证码
    $('#' + elSelector.authCodeContainer).hide();
  },
      showLogined = function showLogined(userName) {
    $('#' + elSelector.userNameLabel).text(userName);
    $('#' + elSelector.logoutPanel).hide();
    $('#' + elSelector.loginedPanel).show();
  };

  // 处理登录和注销后的局部刷新
  Member.addEventListener('logined', showLogined);
  Member.addEventListener('logout', showLoginForm);
  // 验证码改变时，修改评论框中的验证码
  Member.addEventListener('authcodechange', function (imgUrl) {
    $('#' + elSelector.authImg + ',#' + elSelector.authImg + suffix).css('background', 'url(' + imgUrl + ') no-repeat center center');
  });
  Member.addEventListener('loginerror', function () {
    $('#' + elSelector.authCodeContainer + ',#' + elSelector.authCodeContainer + suffix).show();
  });
  $('#' + elSelector.authImg + ',#' + elSelector.authImg + suffix).click(function () {
    Member.getNewAuthCode();
  });
  Member.addEventListener('needverify', function (userName) {
    $('#' + elSelector.authCodeContainer + ',#' + elSelector.authCodeContainer + suffix).show();
  }).addEventListener('notneedverify', function (userName) {
    $('#' + elSelector.authCodeContainer + ',#' + elSelector.authCodeContainer + suffix).hide();
  });
  $('#' + elSelector.username + ',#' + elSelector.username + suffix).change(function () {
    Member.needVerifyCode(this.value);
  });
});

!function () {

  var getDom = function getDom(el, doc) {
    if (!el) {
      return el;
    }
    if (typeof el === 'string') {
      return (doc || document).getElementById(el.replace(/^#/, ''));
    }
    if (!el.nodeName && el.length && el[0] && el[0].nodeName) {
      // 如果是一个jquery对象
      return el[0];
    }
    return el;
  };

  // ----end module全局变量(elSelector,suffix),初始化后只读----//
  function appendReply() {
    var commentLoginBoxReply = getDom('commentLoginBox_reply'),
        commentLoginBox = getDom('commentLoginBox');
    if (commentLoginBoxReply) {
      // 如果页面中有用于回复的评论块，则进行替换操作
      var ids = [];
      for (var key in elSelector) {
        if (elSelector.hasOwnProperty(key)) {
          ids.push(elSelector[key]);
        }
      }
      // IE中innerHTML返回的元素的属性值可能没有在双引号中。
      // 由于一些元素的id可能为另一些id的前缀，所以为了尽可能多的匹配，长的id放前面优先匹配。
      var reg = new RegExp('(\\s+id=([\'"]|))(' + ids.sort(function (a, b) {
        return b.length - a.length;
      }).join('|') + ')(\\2)', 'gi');
      commentLoginBoxReply.innerHTML = commentLoginBox.innerHTML.replace(reg, function ($0, $1, $2, $3, $4) {
        return $1 + $3 + suffix + $4;
      });
    }

    // 处理登录和注销后的局部刷新
    Member.addEventListener('logined', function (userName) {
      showLogined(userName, true);
    });
    Member.addEventListener('logout', function () {
      showLoginForm(true);
    });
  }

  function showLoginForm(reply) {
    var panelId = elSelector.loginPanel,
        authCodeContainerId = elSelector.authCodeContainer,
        frmId = elSelector.loginFrm,
        panelEl,
        authCodeContainerEl,
        frmEl;
    if (reply) {
      panelId += suffix;
      authCodeContainerId += suffix;
      frmId += suffix;
    }
    panelEl = getDom(panelId);
    authCodeContainerEl = getDom(authCodeContainerId);
    frmEl = getDom(frmId);

    frmEl.reset();
    getDom(!reply ? elSelector.loginedPanel : elSelector.loginedPanel + suffix).style.display = 'none';
    getDom(!reply ? elSelector.logoutPanel : elSelector.logoutPanel + suffix).style.display = 'block';

    // 隐藏验证码
    getDom(!reply ? elSelector.authCodeContainer : elSelector.authCodeContainer + suffix).style.display = 'none';
  }
  function showLogined(userName, reply) {
    $('#' + (!reply ? elSelector.userNameLabel : elSelector.userNameLabel + suffix)).text(userName);
    getDom(!reply ? elSelector.logoutPanel : elSelector.logoutPanel + suffix).style.display = 'none';
    getDom(!reply ? elSelector.loginedPanel : elSelector.loginedPanel + suffix).style.display = 'block';
  }
  // 初始化评论框

  Member.initComment = function (ele) {
    $.ajax({
      url: window.frontAppContext + 'front/contents/' + localsForComment.contentID + '/commentcount',
      type: 'GET',
      success: function success(response) {
        response = response.data[0];
        if (response.commentTotal) {
          localsForComment.commentTotal = response.commentTotal;
        }
        if (response.personTotal) {
          localsForComment.personTotal = response.personTotal;
        }
        $(ele).find(".comment-total").each(function () {
          $(this).text(localsForComment.commentTotal);
        });
        $(ele).find(".comment-persontotal").each(function () {
          $(this).text(localsForComment.personTotal);
        });
      }
    });

    $(ele).find('.comment-listlink').each(function () {
      var href = window.siteURL + "comment/list/index.shtml?contentID=" + localsForComment.contentID + "&siteID=" + window.siteID;
      $(this).attr('href', href);
    });
  };

  // 登录处理
  Member.commentLogin = function (event) {
    var event = event || window.event,
        target = event.target || event.srcElement,
        usernameElId = elSelector.username,
        passwordElId = elSelector.password,
        authCodeElId = elSelector.authCode,
        siteIDElId,
        isReply = target.id !== elSelector.loginBtn;
    if (isReply) {
      // 回复容器中的登录处理
      usernameElId = elSelector.username + suffix;
      passwordElId = elSelector.password + suffix;
      authCodeElId = elSelector.authCode + suffix;
    }

    var dc = {
      userName: getDom(usernameElId).value,
      password: getDom(passwordElId).value
    };
    if (Member.isNeedVerifyCode) {
      dc.authCode = getDom(authCodeElId).value;
      dc.isVerifyCode = true;
    }
    Member.jsonpLogin(dc);
  };
  // 退出处理
  function commentLogout() {
    Member.jsonpLogout();
  }

  // 添加评论
  Member.addComment = function (ele) {
    var comment = $(ele).closest('.comment');
    if (comment.length == 0) {
      Dialog.alert('评论框未处于含有.comment样式的元素内!');
      return;
    }
    var content = comment.find('.comment-content').val();

    if (cmt_isNeedLogin && !Member.isLogined) {
      Dialog.alert(localsForComment.comment_CommentLoginFirst || '请先登录再进行留言');
      return false;
    } else if (!content.trim()) {
      Dialog.alert(localsForComment.comment_CommentContentEmpty || '留言内容不能为空');
      return;
    } else if (content.length > 200) {
      // 最大长度200
      Dialog.alert(localsForComment.comment_ContentMore || '输入的内容不能多于200个字');
      return false;
    }
    var parentID = 0;
    var functions = comment.closest('.comment-functions'); // 如果是在回复处直接显示评论框则应被含有.comment-function的元素包裹
    if (functions.length != 0) {
      parentID = functions.attr('parentID');
    }
    var dc = {
      ContentID: localsForComment.contentID,
      SiteID: siteID,
      CmntContent: content,
      ParentID: parentID,
      isAnonymous: comment.find('.comment-anonymous').prop('checked')
    };
    $.ajax({
      url: window.frontAppContext + 'front/comments',
      type: 'POST',
      data: dc,
      crossDomain: true,
      xhrFields: {
        withCredentials: true
      },
      success: function success(response) {
        if (!response.status) {
          Dialog.alert(response.message);
          return;
        }

        Dialog.tips(response.message);
        setTimeout(function () {
          window.location.href = safeUrl($('.comment-listlink').attr('href'));
        }, 1000);
      }
    });
  };

  var showresult = function showresult(response) {
    if (response.Status) {
      Member.initFaceVote();
    } else {
      Dialog.alert(response.Message);
    }
  };

  // 添加表情评论
  Member.addFaceVote = function (faceId) {
    var dc = {
      contentID: localsForComment.contentID,
      catalogID: localsForComment.catalogID,
      contentType: localsForComment.contentType,
      faceId: faceId
    };
    $.ajax({
      url: window.frontAppContext + 'front/commentfaces',
      type: 'POST',
      data: dc,
      success: function success(response) {
        if (response.data.status) {
          Member.initFaceVote();
        } else {
          Dialog.tips(response.data.message);
        }
      }
    });
  };

  // 初始化表情评论,FaceIDs允许设置只显示某些表情
  Member.initFaceVote = function () {
    if ($('.moods').length == 0) {
      return;
    }
    var dc = {
      siteID: siteID,
      contentID: localsForComment.contentID,
      catalogID: localsForComment.catalogID
      // FaceIDs : "170,174,467"//多个表情以逗号分割
    };
    $.ajax({
      url: window.frontAppContext + 'front/contents/' + localsForComment.contentID + '/commentfaces',
      type: 'GET',
      data: dc,
      success: function success(response) {
        Member.showVote(response);
      }
    });
  };
  // 显示表情评论
  Member.showVote = function (data) {

    data = data.data || data;
    // data的数据结构:[{VoteResult:'',Percent:'',srcurl:'',VoteMood:''}...]
    var listvotehtml = '';

    var tmp = $('.mood_template').html();
    var length = data.length;
    var size = parseInt(12 / length);
    var allMinWidth = document.getElementsByClassName("mood")[0].offsetWidth;
    var minWidth = allMinWidth / length;
    if (size == 0) {
      size = 1;
    }
    for (var j = 0; j < length; j++) {
      // 适配
      var dataItem = {
        minWidth: minWidth,
        Size: size,
        VoteResult: data[j].voteResult,
        Percent: data[j].percent,
        srcurl: data[j].srcUrl.indexOf("http") == 0 ? data[j].srcUrl : window.frontAppContext + data[j].srcUrl,
        VoteMood: data[j].voteMood,
        faceId: data[j].faceId,
        Visibility: parseFloat(data[j].percent) ? 'visible' : 'hidden'
      };
      listvotehtml += util.string.tmpl(tmp, dataItem);
    }
    $('.moods').html(listvotehtml);
  };

  // 点击评论列表中回复按钮调用的函数
  var reply = function reply(el) {
    var id = el.getAttribute('data');
    var cmt_ParentID_reply = getDom(elSelector.parent + suffix);
    if (cmt_ParentID_reply) {
      cmt_ParentID_reply.value = id;
    }
    var replyWrap = getDom('reply_' + id);
    var replyBox = getDom('replyBox');
    if (replyWrap.childNodes.length < 1) {
      replyWrap.appendChild(getDom('replyBox'));
      replyBox.style.display = 'block';
    } else {
      replyBox.style.display = replyBox.style.display == 'none' ? 'block' : 'none';
    }
  };
  //
  var commsupportData = {};
  // 处理对评论列表中的评论的"支持"、"反对"
  Member.commentSupport = function (type, ele) {
    var functions = $(ele).closest('.comment-functions');
    if (functions.length == 0) {
      return;
    }

    var parentID = functions.attr('parentID');
    var dc = {
      ID: parentID,
      type: type,
      catalogID: localsForComment.catalogID,
      siteID: localsForComment.siteID
    };
    $.ajax({
      url: window.frontAppContext + 'front/comments/' + parentID + '/' + type,
      type: 'PUT',
      data: dc,
      success: function success(res) {
        if (res.status === 1) {
          var span = $(ele).find('span');
          span.text(parseInt(span.text()) + 1);
        } else if (res.message !== '') {
          Dialog.alert(res.message);
        }
      }
    });
  };

  var Comment = {
    reply: reply,
    // 处理评论列表中的回复点击事件（展开评论编辑块）
    showVote: Member.showVote,
    // 初始化页面时显示表情投票信息
    submitMoodInit: Member.addFaceVote,
    // 点击表情图标时触发的jsonp中的callback
    showresult: showresult,
    // 表情投票后刷新结果
    commentLogout: commentLogout,
    // 登出
    commSupport: Member.commentSupport // 响应评论列表中的支持或反对
  };

  window.Comment = Comment;
  module.exports = Comment;
}();

/***/ }),

/***/ "./siteassets_src/imageCarousel/index.js":
/*!***********************************************!*\
  !*** ./siteassets_src/imageCarousel/index.js ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/* global $ */
__webpack_require__(/*! ../jslib/fullScreenApi.js */ "./siteassets_src/jslib/fullScreenApi.js");
$(function () {
  if (window.Hammer) {
    // Hammer.js作为jqeury插件
    var hammerify = function hammerify(el, options) {
      var $el = $(el);
      if (!$el.data('hammer')) {
        $el.data('hammer', new Hammer($el[0], options));
      }
    };

    $.fn.hammer = function (options) {
      return this.each(function () {
        hammerify(this, options);
      });
    };

    // extend the emit method to also trigger jQuery events
    window.Hammer.Manager.prototype.emit = function (originalEmit) {
      return function (type, data) {
        originalEmit.call(this, type, data);
        $(this.element).trigger({
          type: type,
          gesture: data
        });
      };
    }(window.Hammer.Manager.prototype.emit);
  }

  var imageCarousel = $('#imageCarousel');
  if (!imageCarousel.length) {
    return;
  }
  // 对图片播放器进行触屏的支持
  $('#imageCarousel').hammer().on('swipeleft', function () {
    $(this).carousel('next');
  });
  $('#imageCarousel').hammer().on('swiperight', function () {
    $(this).carousel('prev');
  });
  // 对键盘快捷键的支持
  $(document).on('keyup', function (e) {
    if (e.keyCode == 39) {
      // ->
      $('#imageCarousel').carousel('next');
    }if (e.keyCode == 37) {
      // <-
      $('#imageCarousel').carousel('prev');
    }
  });
  // 对全屏的支持
  FullScreenApi.init();
  $('#imageCarousel2FullScreen').on('click', function (e) {
    if (FullScreenApi.supportsFullScreen) {
      FullScreenApi.requestFullScreen($('#imageCarousel').get(0));
    } else {
      Dialog.tips('您的浏览器不支持全屏观看。');
    }
  });
  // 对列表和大图模式切换
  $('#viewModeTrigger').on('click', function (e) {
    if ($('#imageCarousel').hasClass('slide-show-list')) {
      $('#imageCarousel').removeClass('slide-show-list');
      $('#viewModeTrigger').find('span:contains(大图查看)').text('列表查看');
    } else {
      $('#imageCarousel').addClass('slide-show-list');
      $('#viewModeTrigger').find('span:contains(列表查看)').text('大图查看');
      $('#imageCarousel').carousel('pause');
    }
  });
});

/***/ }),

/***/ "./siteassets_src/jslib/fullScreenApi.js":
/*!***********************************************!*\
  !*** ./siteassets_src/jslib/fullScreenApi.js ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


// 全屏工具方法

var FullScreenApi = {
  browserPrefix: '',
  supportsFullScreen: false,
  isFullScreen: function isFullScreen() {
    switch (this.browserPrefix) {
      case '':
        return document.fullScreen;
      case 'webkit':
        return document.webkitIsFullScreen;
      default:
        return document[this.browserPrefix + 'FullScreen'];
    }
  },
  fullscreenchange: function fullscreenchange() {
    return this.browserPrefix === '' ? 'fullscreenchange' : this.browserPrefix + 'fullscreenchange';
  },
  requestFullScreen: function requestFullScreen(el) {
    return this.browserPrefix === '' ? el.requestFullScreen() : el[this.browserPrefix + 'RequestFullScreen']();
  },
  cancelFullScreen: function cancelFullScreen(el) {
    return this.browserPrefix === '' ? el.cancelFullScreen() : el[this.browserPrefix + 'CancelFullScreen']();
  },
  zoomInIcon: function zoomInIcon(imgWrapEl) {
    switch (this.browserPrefix) {
      case '':
        imgWrapEl.style.cursor = 'pointer';
      case 'webkit':
        imgWrapEl.style.cursor = '-webkit-zoom-in';
      default:
        imgWrapEl.style.cursor = '-moz-zoom-in';
    }
  },
  zoomOutIcon: function zoomOutIcon(imgWrapEl) {
    switch (this.browserPrefix) {
      case '':
        imgWrapEl.style.cursor = 'pointer';
      case 'webkit':
        imgWrapEl.style.cursor = '-webkit-zoom-out';
      default:
        imgWrapEl.style.cursor = '-moz-zoom-out';
    }
  },
  init: function init() {
    if (typeof document.cancelFullScreen !== 'undefined') {
      this.supportsFullScreen = true;
    } else {
      var pfxArr = ['webkit', 'moz', 'ms', 'o', 'khtml'];
      for (var i = 0, len = pfxArr.length; i < len; i++) {
        this.browserPrefix = pfxArr[i];
        if (typeof document[this.browserPrefix + 'CancelFullScreen'] !== 'undefined') {
          this.supportsFullScreen = true;
          break;
        }
      }
    }
  }
};

window.FullScreenApi = FullScreenApi;
module.exports = FullScreenApi;

/***/ }),

/***/ "./siteassets_src/member/index.js":
/*!****************************************!*\
  !*** ./siteassets_src/member/index.js ***!
  \****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/* global $ */
var z = window.Zving || {};
z.Member = z.Member || {};
var Member = z.Member;
window.Member = Member;

// 会员登录信息显示
function showMemberName() {
  var name = Cookie.get('_ZMemberName');
  if (name) {
    $('.member-span-logined').removeClass('hide');
    $('.member-username').text(name);
    $('.member-username').attr('href', window.siteURL + 'member/info.shtml?siteID=' + escapeQueryValue(siteID));
  } else {
    $('.member-span-login').removeClass('hide');
  }
  var url = escapeQueryValue(window.location.href);

  if (url.indexOf('referer') > -1) {
    url = url.substring(url.indexOf('referer') + 10);
    url = escapeQueryValue(url);
  }
  $('.member-register').attr('href', window.siteURL + 'member/register.shtml?siteID=' + escapeQueryValue(siteID) + '&referer=' + url);
  $('.member-login').attr('href', window.siteURL + 'member/member_login.shtml?siteID=' + escapeQueryValue(siteID) + '&referer=' + url);
  // $('.member-logout').attr('href', window.frontAppContext + 'front/member/logout?siteID=' + escapeQueryValue(siteID) + '&referer=' + url)
  $('.member-forgetpassword').attr('href', window.siteURL + 'member/forget/index.shtml?siteID=' + escapeQueryValue(siteID) + '&referer=' + url);
  $('.message-list').each(function () {
    $(this).attr('href', window.siteURL + 'member/message_list.shtml?siteID=' + escapeQueryValue(siteID) + '&code=' + $(this).attr('code'));
  });
}
var clearMemberLoginInfo = function clearMemberLoginInfo() {
  Member.isLogined = false;
  Cookie.remove('ZVING_MEMBER_LOGIN_ID');
  Cookie.remove('_ZMemberName', '/');
  Cookie.remove('_ZMemberStand', '/');
  Cookie.remove('Authorization', '/');
  Member.isLogined = false;
};

$(function () {

  // 在这个电脑上记住我
  if (Cookie.get('_ZMemberStand') && !Cookie.get('_ZMemberName')) {
    $.ajax({
      url: window.frontAppContext + 'front/member/rememberme',
      success: function success(response) {
        showMemberName();
      }
    });
    // Server.sendRequest("Member.RememberMe", {}, function(response) {
    // 	showMemberName();
    // });
  } else {
    // 前端应用和静态页面域名可能不同
    if (!Cookie.get('_ZMemberName')) {
      $.ajax({
        url: window.frontAppContext + 'front/member/logined',
        crossDomain: true,
        xhrFields: {
          withCredentials: true
        },
        success: function success(result) {
          result = result && result.data;
          Cookie.set('_ZMemberName', result.userName || '', null, '/');
          showMemberName();
        }
      });

      // Server.sendRequest('member/logined', {}, function(result) {
      // 	Cookie.set("_ZMemberName",result.UserName,null,"/");
      // 	showMemberName();
      // });
    } else {
      showMemberName();
    }
  }

  // 退出登录
  $('.member-logout').click(function (e) {
    e.preventDefault();
    var $this = $(this);
    $this.addClass('status-doing');
    $.ajax({
      url: window.frontAppContext + 'front/member/logout?' + new Date().getTime(),
      type: 'POST',
      success: function success(data) {
        clearMemberLoginInfo();
        Member.trigger('logout');
        if (location.href.indexOf('/member/') > 0) {
          location.href = safeUrl(window.siteURL);
        } else {
          location.reload();
        }
      }
    });
  });
});

$(function () {
  // 检测用户名
  $('.register-userName').change(function () {
    var $this = $(this);
    $.ajax({
      url: window.frontAppContext + 'front/member/register/checkusername',
      type: 'GET',
      data: { 'userName': $this.val() },
      success: function success(response) {
        var t = $this;
        if (response.data.count == 0) {
          t.removeAttr('hasVerifyError');
          t.removeAttr('verifyMessage');
        } else {
          t.attr('hasVerifyError', true);
          t.attr('verifyMessage', '账号己被其他用户使用!');
        }
        Verify.checkOne(null, t.get(0));
      }
    });
  });
  // 电子邮箱
  $('.register-email').change(function () {
    var $this = $(this);
    var val = $this.val();
    if (val === '') {
      $this.removeAttr('hasVerifyError');
      $this.removeAttr('verifyMessage');
      $this.closest('.has-feedback').removeClass('has-error has-success');
      // Verify.checkOne(null, $this.get(0))
    } else if (/^\w+([\-+.]\w+)*@\w+([\-.]\w+)*\.\w+([\-.]\w+)*$/.test(val)) {
      $.ajax({
        url: window.frontAppContext + 'front/member/register/checkemail',
        type: 'GET',
        data: { 'email': val },
        success: function success(response) {
          if (response.data.count == 0) {
            $this.removeAttr('hasVerifyError');
            $this.removeAttr('verifyMessage');
          } else {
            $this.attr('hasVerifyError', true);
            $this.attr('verifyMessage', '电子邮箱己被其他用户使用!');
          }
          Verify.checkOne(null, $this.get(0));
        }
      });
    }
  });

  // 验证码
  $('.verify-code-img').attr('src', window.frontAppContext + 'front/authcode_url?' + new Date().getTime());
  $('.verify-code-img').parent().css('padding-top', '0px').css('padding-bottom', '0px');
  $('.verify-code-img').click(function () {
    $(this).attr('src', window.frontAppContext + 'front/authcode_url?' + new Date().getTime());
  });

  $('.verify-code').keyup(function () {
    if ($(this).val().length != 5) {
      $(this).attr('hasVerifyError', true);
      $(this).attr('verifyMessage', '验证码不正确!');
      return;
    }
    $.ajax({
      url: window.frontAppContext + 'front/member/register/verifycode',
      type: 'GET',
      crossDomain: true,
      xhrFields: {
        withCredentials: true
      },
      data: { 'verifyCode': $(this).val() },
      success: function success(response) {
        var vc = $('.verify-code');
        if (response.data.flag) {
          vc.removeAttr('hasVerifyError');
          vc.removeAttr('verifyMessage');
        } else {
          vc.attr('hasVerifyError', true);
          vc.attr('verifyMessage', '验证码不正确!');
        }
        Verify.checkOne(null, vc.get(0));
      }
    });

    // Server.sendRequest("Login.verifyCodeCheck", {
    // 	"VerifyCode" : $(this).val()
    // }, function(response) {
    // 	var vc = $(".verify-code");
    // 	if (response.Flag) {
    // 		vc.removeAttr("hasVerifyError");
    // 		vc.removeAttr("verifyMessage");
    // 	} else {
    // 		vc.attr("hasVerifyError", true);
    // 		vc.attr("verifyMessage", "验证码不正确!");
    // 	}
    // 	Verify.checkOne(null, vc.get(0));
    // });
  });

  // 密码及重复密码
  $('.password-confirm').keyup(function () {
    var p = $('.password').val();
    if (p != $(this).val()) {
      $(this).attr('hasVerifyError', true);
      $(this).attr('verifyMessage', '两次输入密码不一致!');
    } else {
      $(this).removeAttr('hasVerifyError');
      $(this).removeAttr('verifyMessage');
      Verify.checkOne(null, $(this).get(0));
    }
  });
  // 所有前端链接统一前缀和后缀
  $("a.front-link").each(function () {
    var href = $(this).attr("href");
    if (!href) {
      return;
    }
    if (href.startsWith('/')) {
      href = href.substring(1);
    }
    if (href.indexOf("?") > 0) {
      href += "&";
    } else {
      href += "?";
    }
    href += "siteID=" + escapeQueryValue(siteID);
    $(this).attr("href", safeUrl(href));
  });
});

!function () {

  window.localsForMebmer = window.localsForMebmer || {};
  window.localsForComment = window.localsForComment || {};
  window.localsForMessageBoard = window.localsForMessageBoard || {};
  var locals;
  locals = $.extend(window.localsForMebmer, window.localsForComment, window.localsForMessageBoard);
  /*
  var jsonpLogin = function (userName, password, authCode) {
    var dc
    if (typeof userName === 'object') {
      dc = userName
    } else {
      dc = {
        userName: userName,
        password: password,
        authCode: authCode || ''
      }
    }
    if (!dc.userName || !dc.password) {
      Dialog.alert("用户名或密码不能为空")
      return
    }
    dc.action = 'login'
    dc.siteID = dc.siteID || locals.siteID
    $.ajax({
      url: window.frontAppContext + 'front/member/ajaxlogin',
      type: 'POST',
      data: dc,
      success: function (res) {
        if (typeof res === 'object') {
          if (res.status != 1) {
            // 登录失败时刷新验证码，抛出验证码改变事件通知各相关页面处理
            Member.isNeedVerifyCode = true
            Member.getNewAuthCode()
            Member.trigger('loginerror', res.data)
          } else {
            Cookie.set('_ZMemberName', res.data && res.data.UserID || dc.UserName, null, '/')
            Member.isLogined = true
            Member.trigger('logined', dc.UserName) // 已登录事件中传递用户名信息，供回调使用
          }
        }
      }
    })
  }
  var jsonpLogout = function () {
    var url =
      window.frontAppContext + 'front/member/ajaxlogout?' + new Date().getTime()
    $.ajax({
      url: url,
      type: 'POST',
      success: function (data) {
        Cookie.remove('ZVING_MEMBER_LOGIN_ID')
        Member.isLogined = false
        Member.trigger('logout')
      }
    })
  }*/

  var showLoginPanel = function showLoginPanel() {
    if ($('#loginPanel').filter(':visible').length) {
      return;
    }
    // 初始化
    $('#loginForm2').get(0).reset();
    // 刷新验证码
    $('#loginAuthCodeImg').css('backgroundImage', 'url(' + CONTEXTPATH + 'front/authcode_url?Height=21&Width=50&' + new Date().getTime() + ')');
    var position = $('#span_login').offset();
    if (position) {
      position.left -= 250;
      position.top = 31;
    } else {
      position = {
        left: $window.width() / 2 - 175,
        top: 30
      };
    }
    $('#loginPanel').css({
      top: position.top + 'px',
      left: position.left + 'px'
    }).show();
    $(document).off('click.toggleloginpanel').on('click.toggleloginpanel', function (evt) {
      if (!$('#loginPanel,#span_login').find(evt.target).length) {
        $('#loginPanel').hide();
      }
    });
  };

  // 会员收藏夹
  Member.addFavorites = function (id, favtype) {
    $.ajax({
      url: window.frontAppContext + 'front/member/logined',
      crossDomain: true,
      xhrFields: {
        withCredentials: true
      },
      success: function success(result) {
        result = result && result.data;
        if (result.isLogin) {
          if (!id || !favtype) {
            Dialog.tips('还有未正确填写的项，请参照提示修改');
            return;
          }
          $.ajax({
            url: window.frontAppContext + 'front/member/favorites/' + favtype + '/' + id,
            crossDomain: true,
            xhrFields: {
              withCredentials: true
            },
            type: 'POST',
            success: function success(data) {
              Dialog.tips(data.message);
            }
          });
        } else {
          // 登录
          Dialog.tips('还未登录，请先登录');
        }
      }
    });
  };
  var Event = {};

  // Member.jsonpLogin = jsonpLogin
  // Member.jsonpLogout = jsonpLogout
  Member.showLoginPanel = showLoginPanel;

  // 用户注册
  /* Member.register = function () {
    var url =
      window.frontAppContext + 'front/member/register?siteID=' + locals.siteID
    var w = window.open(url, '_blank', '')
    if (!w) {
      Dialog.alert(locals.Contentcore_WindowBlocked)
    }
  } */
  Member.addEventListener = function (type, fn) {
    var listeners = Event[type] = Event[type] || [];
    listeners.push(fn);
    return this;
  };
  Member.removeEventListener = function (type, fn) {
    var listeners = Event[type];
    if (listeners && listeners.length) {
      var index = listeners.indexOf(fn);
      if (index > -1) {
        listeners.splice(index, 1);
      }
    }
    return this;
  };
  Member.trigger = function (type, data) {
    var listeners = Event[type] || [];
    for (var i = 0; i < listeners.length; i++) {
      listeners[i](data);
    }
    return this;
  }, Member.isLogined = false;

  Member.Event = Event;
  var authCodeImg = new Image();
  authCodeImg.onload = function () {
    Member.trigger('authcodechange', authCodeImg.src);
  };
  Member.getNewAuthCode = function () {
    authCodeImg.src = window.frontAppContext + 'front/authcode_url?Height=21&Width=50&' + new Date().getTime();
  };
  // 判断是否需要验证码，且结果处理后抛出相关事件通知相关模块处理
  Member.needVerifyCode = function (username) {
    $.ajax({
      url: window.frontAppContext + 'front/member/login/verifycode',
      data: { userName: username },
      success: function success(result) {
        if (result === 'true') {
          // 需要验证码时，刷新验证码
          Member.isNeedVerifyCode = true;
          Member.getNewAuthCode();
          Member.trigger('needverify');
        } else {
          // 不需要时，各功能组件隐藏验证码
          Member.isNeedVerifyCode = false;
          Member.trigger('notneedverify');
        }
      }
    });
  };
  Member.isNeedVerifyCode = false; // 内部保留当前输入用户是否需要验证码的状态。默认不需要验证码。

  // 页面初始化后看是否已登录,页面默认处于未登录状态
  $(window).load(function () {
    locals = $.extend({
      FrontAppContext: window.frontAppContext
    }, window.localsForMebmer, window.localsForComment, window.localsForMessageBoard);

    // 如果指定了登录后的跳转页面，则登录后直接跳转
    if (locals.SiteLink && window.needRedirect) {
      Member.addEventListener('logined', function (jsonpData) {
        window.location = locals.SiteLink;
      });
    } else {
      Member.addEventListener('logined', function (jsonpData) {
        showMemberName();
      });
    }
    $.ajax({
      url: window.frontAppContext + 'front/member/logined',
      crossDomain: true,
      xhrFields: {
        withCredentials: true
      },
      success: function success(result) {
        result = result && result.data;
        if (typeof result !== 'undefined') {
          if (result.isLogin) {
            Member.isLogined = result.isLogin;
            Member.trigger('logined', result.userName);
          } else {
            if (result.SSOLogin) {
              $.ajax({
                url: result.SSOURL + '/Online?ContentType=jsonp',
                dataType: 'jsonp',
                success: function success(userInfo) {
                  if (userInfo && userInfo.Login) {
                    Member.isLogined = true;
                    Member.trigger('logined', userInfo.Name);
                  }
                }
              });
            } else {
              clearMemberLoginInfo();
              // showMemberName()
            }
          }
        }
      }
    });
  });

  module.exports = Member;
}();

/***/ }),

/***/ "./siteassets_src/messageboard/index.js":
/*!**********************************************!*\
  !*** ./siteassets_src/messageboard/index.js ***!
  \**********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/* global $ */
var z = window.Zving || {};
z.Member = z.Member || {};
var Member = z.Member;
window.Member = Member;

var MaxLength = 200;
var msg_isNeedLogin = false;
var elSelector = {
  messageBoard: 'msgBoard',
  contentInput: '.message-content',
  counter: 'msg_contentCount',
  chkAnonymous: '.message-anonymous',
  submitBtn: 'msg_submit',
  loginContainer: 'msg_loginContainer',
  username: 'msg_username',
  password: 'msg_password',
  authCode: 'msg_authCode',
  authImg: 'msg_authCodeImg',
  loginBtn: 'msg_frmbutton',
  // commentCount : 'msg_commtotal',
  // personCount : 'msg_commusertotal',
  registerBtn: 'msg_reg',

  userNameLabel: 'msg_userNameLabel',
  loginedPanel: 'msg_logined', // 登录状态内容显示容器
  logoutPanel: 'msg_login', // 未登录状态内容显示容器
  authCodeContainer: 'msg_authCodeContainer',
  loginFrm: 'msg_frm'
};

$(function () {
  if (!window.localsForMessageBoard) {
    return;
  }
  var getDom = function getDom(el, doc) {
    if (!el) {
      return el;
    }
    if (typeof el === 'string') {
      return (doc || document).getElementById(el.replace(/^#/, ''));
    }
    if (!el.nodeName && el.length && el[0] && el[0].nodeName) {
      // 如果是一个jquery对象
      return el[0];
    }
    return el;
  };

  var showLoginForm = function showLoginForm(reply) {
    var panelId = elSelector.loginPanel,
        authCodeContainerId = elSelector.authCodeContainer,
        frmId = elSelector.loginFrm,
        panelEl,
        authCodeContainerEl,
        frmEl;

    panelEl = getDom(panelId);
    authCodeContainerEl = getDom(authCodeContainerId);
    frmEl = getDom(frmId);

    frmEl.reset();
    $('#' + elSelector.loginedPanel).hide();
    $('#' + elSelector.logoutPanel).show();
    // 隐藏验证码
    $('#' + elSelector.authCodeContainer).hide();
  },
      showLogined = function showLogined(userName) {
    $('#' + elSelector.userNameLabel).text(userName);
    $('#' + elSelector.logoutPanel).hide();
    $('#' + elSelector.loginedPanel).show();
  },

  // 登录处理
  msgLogin = function msgLogin(event) {
    var event = event || window.event,
        target = event.target || event.srcElement,
        usernameElId = elSelector.username,
        passwordElId = elSelector.password,
        authCodeElId = elSelector.authCode,
        siteIDElId;

    var dc = {
      UserName: getDom(usernameElId).value,
      Password: getDom(passwordElId).value
    };

    if (Member.isNeedVerifyCode) {
      dc.AuthCode = getDom(authCodeElId).value;
      dc.IsVerifyCode = true;
    }
    Member.jsonpLogin(dc);
  };

  // 添加留言
  Member.addMessage = function (isNeedLogin, boardId) {
    msg_isNeedLogin = msg_isNeedLogin || isNeedLogin;
    boardId = boardId || localsForMessageBoard.Request_boardId;
    var $contentEl = $(elSelector.contentInput);
    var content = $contentEl.val().trim();
    if (msg_isNeedLogin && !Member.isLogined) {
      Dialog.alert(localsForMessageBoard.Messageboard_LoginFirst || '请先登录再进行留言');
      return;
    } else if (content == '' || content == localsForMessageBoard.Messageboard_CivilizedMessages) {
      Dialog.alert(localsForMessageBoard.Messageboard_ContentEmpty || '留言内容不能为空');
      $contentEl.get(0).focus();
      return false;
    } else if (content.length > MaxLength) {
      Dialog.alert(localsForMessageBoard.Messageboard_ContentMore || '输入的内容不能多于200个字');
      return false;
    }
    var dc = {
      boardID: boardId,
      siteID: localsForMessageBoard.SiteID,
      // Title: '',
      content: content,
      anonymous: $(elSelector.chkAnonymous).prop('checked')
    };
    $.ajax({
      url: window.frontAppContext + 'front/member/message/submit',
      type: 'POST',
      data: dc,
      success: function success(response) {
        if (response.status) {
          Dialog.tips(response.message);
          setTimeout(function () {
            window.location.reload();
          }, 1000);
        } else {
          Dialog.alert(response.message);
        }
      }
    });
  };

  if (!getDom(elSelector.messageBoard)) {
    return;
  }
  msg_isNeedLogin = localsForMessageBoard.IsNeedLogin == 'true';
  // 提交
  $('#' + elSelector.submitBtn).click(function () {
    Member.addMessage(msg_isNeedLogin, localsForMessageBoard.Request_boardId);
  });
  // 注册
  $('#' + elSelector.registerBtn).click(Member.register);
  // 登录
  $('#' + elSelector.loginBtn).click(msgLogin);
  $(elSelector.contentInput).on('keyup', function () {
    var len = this.value.length;
    var counterEl = getDom(elSelector.counter);
    counterEl.innerHTML = len;
  }).on('click', function () {
    if (this.innerHTML == localsForMessageBoard.Messageboard_CivilizedMessages) {
      this.innerHTML = '';
    }
  });
  // 验证码改变时，修改评论框中的验证码
  Member.addEventListener('authcodechange', function (imgUrl) {
    $('#' + elSelector.authImg).css('background', 'url(' + imgUrl + ') no-repeat center center');
  });
  Member.addEventListener('loginerror', function () {
    $('#' + elSelector.authCodeContainer).show();
  });
  $('#' + elSelector.authImg).click(function () {
    Member.getNewAuthCode();
  });
  Member.addEventListener('needverify', function (userName) {
    $('#' + elSelector.authCodeContainer).show();
  }).addEventListener('notneedverify', function (userName) {
    $('#' + elSelector.authCodeContainer).hide();
  });
  $('#' + elSelector.username).change(function () {
    Member.needVerifyCode(this.value);
  });
  Member.addEventListener('logined', showLogined).addEventListener('logout', showLoginForm);
});

module.exports = Member;

/***/ }),

/***/ "./siteassets_src/misc/addFavorite.js":
/*!********************************************!*\
  !*** ./siteassets_src/misc/addFavorite.js ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/* global $ */
$(function () {
  // 站点加入收藏
  $('.site-favorites').click(function () {
    var url = $(this).attr('url');
    var title = $(this).attr('title');
    if (url == 'http:///') {
      return;
    }
    try {
      window.external.addFavorite(safeUrl(url), title);
    } catch (e) {
      try {
        window.sidebar.addPanel(title, safeUrl(url), '');
      } catch (e) {
        Dialog.tips('加入收藏失败,请按Ctrl+D进行收藏');
      }
    }
  });
});

/***/ }),

/***/ "./siteassets_src/search/index.js":
/*!****************************************!*\
  !*** ./siteassets_src/search/index.js ***!
  \****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/* global $ */
$(function () {
  // 搜索事件
  $('.search').each(function () {
    var ele = this;
    $(ele).find('.search-query').focus(function () {
      var b = $(ele).find('.search-submit');
      if (b) {
        b.addClass('enterclick');
      }
    });
    $(ele).find('.search-query').blur(function () {
      var b = $(ele).find('.search-submit');
      if (b) {
        b.removeClass('enterclick');
      }
    });
    $(ele).find('.search-submit').click(function () {
      var q = $(ele).find('.search-query');
      var s = $(ele).find('.search-synonym');
      var t = $(ele).find('.search-titleonly');
      if (q.val()) {
        var url = window.siteURL + 'search/result.shtml?siteID=' + escapeQueryValue(siteID) + '&query=' + escapeQueryValue(q.val());
        if (s.attr('checked')) {
          url += '&usingSynonym=Y';
        }
        if (t.val()) {
          url += '&titleOnly=' + escapeQueryValue(t.val());
        }
        window.location.href = safeUrl(url);
      }
    });
  });

  // 搜索热词加链接
  $('.searchwords a').each(function () {
    var url = window.frontAppContext + 'search/result?SiteID=' + escapeQueryValue(siteID) + '&Query=' + escapeQueryValue($(this).text());
    $(this).attr('href', safeUrl(url));
  });

  // 加了enterclick的元素会自动响应回车键
  $(document).keyup(function (e) {
    if (e.which == 13) {
      $('.enterclick:first').click();
    }
  });
});

/***/ }),

/***/ 0:
/*!*************************************************************************************************************************************************************************************************************************************!*\
  !*** multi ./siteassets_src/member/index.js ./siteassets_src/comment/index.js ./siteassets_src/messageboard/index.js ./siteassets_src/imageCarousel/index.js ./siteassets_src/search/index.js ./siteassets_src/misc/addFavorite.js ***!
  \*************************************************************************************************************************************************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(/*! ./siteassets_src/member/index.js */"./siteassets_src/member/index.js");
__webpack_require__(/*! ./siteassets_src/comment/index.js */"./siteassets_src/comment/index.js");
__webpack_require__(/*! ./siteassets_src/messageboard/index.js */"./siteassets_src/messageboard/index.js");
__webpack_require__(/*! ./siteassets_src/imageCarousel/index.js */"./siteassets_src/imageCarousel/index.js");
__webpack_require__(/*! ./siteassets_src/search/index.js */"./siteassets_src/search/index.js");
module.exports = __webpack_require__(/*! ./siteassets_src/misc/addFavorite.js */"./siteassets_src/misc/addFavorite.js");


/***/ })

/******/ });

function safeUrl(v) {
    if(!v || !v.replace) return v;
  if (!/^(#|https?:\/\/|mailto:|tel:|data:image\/|ftp:\/\/|(\.){0,2}\/|[-\.\w]+\/|[-\.\w]+\.[\w]+$)/.test(v)) return '#';
  return v.replace(/"/g, '%22').replace(/'/g, '%27').replace(/\(/g, '%28').replace(/\)/g, '%29').replace(/</g, "%3C").replace(/>/g, "%3E").replace(/`/g, '%60')
}
function escapeQueryValue(v) {
    if(!v || !v.replace) return v;
    return v.replace(/\#/g,"%23").replace(/\&/g,"%26").replace(/\(/g, '%28').replace(/\)/g, '%29').replace(/\+/g,"%2B").replace(/=/g,"%3D").replace(/\?/g,"%3F")
}
function escapeHtml(v) {
    if(!v || !v.replace) return v;
  return v.replace(/"/g, '&quot;').replace(/'/g, '&#39;').replace(/\(/g, '&#28;').replace(/\)/g, '&#29;').replace(/</g, "&lt;").replace(/>/g, "&gt;")
}
